/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class DraftAutoRemitTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DraftAutoRemitTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u81ea\u52a8\u7968\u636e\u89e3\u4ed8\u626b\u63cf\u5f00\u59cb...");
        ArrayList<QFilter> tQFilterList = new ArrayList<QFilter>(0);
        tQFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        tQFilterList.add(new QFilter("draftbillstatus", "=", (Object)"registered"));
        tQFilterList.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        tQFilterList.add(new QFilter("rptype", "=", (Object)"paybill"));
        tQFilterList.add(new QFilter("isendorsepay", "=", (Object)"0"));
        Date today = new Date();
        tQFilterList.add(new QFilter("draftbillexpiredate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        tQFilterList.add(new QFilter("draftbillexpiredate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        DynamicObjectCollection payablebill = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])tQFilterList.toArray(new QFilter[0]));
        if (payablebill != null && payablebill.size() > 0) {
            logger.info("payablebill is :" + payablebill.size());
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", DraftTradeTypeEnum.PAYOFF.getValue());
            option.setVariableValue("isfromauto", "y");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"autoremit", (String)"cdm_payablebill", (Object[])payablebill.stream().map(v -> v.getLong("id")).toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                logger.info(operationResult.getMessage());
            }
        } else {
            logger.info("payablebill is null:");
        }
        logger.info("\u81ea\u52a8\u7968\u636e\u89e3\u4ed8\u5904\u7406\u7ed3\u675f...");
    }
}

