/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAutoRlspledgeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DraftAutoRlspledgeTask.class);

    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        logger.info("DraftAutoRlspledgeTask start...");
        int day = 1;
        if (paramMap != null && !paramMap.isEmpty()) {
            Object dayParam = paramMap.get("day");
            if (EmptyUtil.isNoEmpty((Object)dayParam)) {
                day = Integer.parseInt(dayParam.toString());
            }
            logger.info("day{}", (Object)day);
        }
        ArrayList<QFilter> tQFilterList = new ArrayList<QFilter>(6);
        tQFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        tQFilterList.add(new QFilter("draftbillstatus", "=", (Object)"pledged"));
        tQFilterList.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        tQFilterList.add(new QFilter("rptype", "=", (Object)"receivebill"));
        Date today = new Date();
        if (EmptyUtil.isNoEmpty((Integer)day)) {
            today = DateUtils.getNextDay((Date)today, (int)day);
        }
        logger.info("today:" + today + ",day:" + day);
        tQFilterList.add(new QFilter("pledgeenddate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        tQFilterList.add(new QFilter("pledgeenddate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        DynamicObject[] receivablebill = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billpool,poollockstatus,poollockorg,company", (QFilter[])tQFilterList.toArray(new QFilter[0]));
        if (receivablebill != null && receivablebill.length > 0) {
            logger.info("receivablebill length:" + receivablebill.length);
            HashSet<Long> billIdSet = new HashSet<Long>();
            HashSet<Long> allBillIdSet = new HashSet<Long>();
            for (DynamicObject recbill : receivablebill) {
                DynamicObject billpool = recbill.getDynamicObject("billpool");
                if (EmptyUtil.isNoEmpty((DynamicObject)billpool)) {
                    boolean poollockstatus = recbill.getBoolean("poollockstatus");
                    if (poollockstatus) {
                        String companyId;
                        String poollockorgId = recbill.getDynamicObject("poollockorg").getPkValue().toString();
                        if (!poollockorgId.equals(companyId = recbill.getDynamicObject("company").getPkValue().toString())) continue;
                        billIdSet.add(recbill.getLong("id"));
                        continue;
                    }
                    billIdSet.add(recbill.getLong("id"));
                    continue;
                }
                allBillIdSet.add(recbill.getLong("id"));
            }
            if (billIdSet.size() > 0) {
                logger.info("billIdSet size is:" + billIdSet.size());
                for (Long billId : billIdSet) {
                    logger.info("start billId is:" + billId);
                    HashSet<Long> bllidSetNew = new HashSet<Long>();
                    bllidSetNew.add(billId);
                    OperationResult operationResultOutPool = OperationServiceHelper.executeOperate((String)"pushout", (String)"cdm_receivablebill", (Object[])bllidSetNew.toArray(), (OperateOption)OperateOption.create());
                    if (!operationResultOutPool.isSuccess()) {
                        logger.info("outPool error:" + operationResultOutPool.getMessage());
                    }
                    DynamicObject[] outBills = null;
                    if (!operationResultOutPool.isSuccess()) {
                        logger.info(OperateServiceHelper.decodeErrorMsg((OperationResult)operationResultOutPool));
                        continue;
                    }
                    QFilter sourceBillFilter = new QFilter("sourcebillid", "in", bllidSetNew);
                    outBills = BusinessDataServiceHelper.load((String)"cdm_billpoolbiz", (String)"id", (QFilter[])sourceBillFilter.toArray());
                    if (outBills == null) {
                        logger.info("outBills is null");
                        continue;
                    }
                    OperationResult result = null;
                    try {
                        OperateOption operateOption = OperateOption.create();
                        Object[] outBillIds = Arrays.stream(outBills).map(DataEntityBase::getPkValue).toArray();
                        result = OperateServiceHelper.execOperate((String)"submit", (String)"cdm_billpoolbiz", (Object[])outBillIds, (OperateOption)operateOption);
                        if (result.isSuccess()) {
                            if (!(result = OperateServiceHelper.execOperate((String)"audit", (String)"cdm_billpoolbiz", (Object[])result.getSuccessPkIds().toArray(), (OperateOption)operateOption)).isSuccess()) {
                                logger.info("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u5ba1\u6838\u5931\u8d25\u3002" + billId);
                                continue;
                            }
                            logger.info("out pool audit succ\uff1a" + billId);
                            allBillIdSet.add(billId);
                            continue;
                        }
                        logger.info("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5931\u8d25\u3002");
                    }
                    catch (Exception e) {
                        logger.error("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\u3002", (Throwable)e);
                    }
                }
                logger.info("allBillIdSet size is:" + allBillIdSet.size());
            }
            OperateOption optionRlsPledge = OperateOption.create();
            optionRlsPledge.setVariableValue("tradeType", DraftTradeTypeEnum.RLSPLEDGE.getValue());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"autorlspledge", (String)"cdm_receivablebill", (Object[])allBillIdSet.toArray(), (OperateOption)optionRlsPledge);
            if (!operationResult.isSuccess()) {
                logger.info("autorlspledge error:" + operationResult.getMessage());
            }
        }
        logger.info("DraftAutoRlspledgeTask end...");
    }

    private void lockDrafts(List<Long> needLockDrafts, Long outBillId) {
        ArrayList<DraftLockInfo> lockDraftList = new ArrayList<DraftLockInfo>();
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillId(outBillId);
        draftLockInfo.setSourceBillType("cdm_billpoolbiz");
        draftLockInfo.setLockBillIdList(needLockDrafts);
        lockDraftList.add(draftLockInfo);
        LockDraftHelper.releaseOrLockDrafts(lockDraftList);
    }
}

