/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class PoolDraftAutoUnlockTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PoolDraftAutoUnlockTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u81ea\u52a8\u89e3\u9501\u7968\u636e\u6c60\u7968\u636e\u626b\u63cf\u5f00\u59cb...");
        DynamicObject[] lockRules = BusinessDataServiceHelper.load((String)"cdm_lockrule", (String)"overtimeunlock,workdaynumber", null);
        if (lockRules.length == 0) {
            return;
        }
        DynamicObject lockRule = lockRules[0];
        if (!lockRule.getBoolean("overtimeunlock")) {
            return;
        }
        int workDayNumber = lockRule.getInt("workdaynumber");
        Date invalidDate = DateUtils.getLastDay((Date)new Date(), (int)workDayNumber);
        QFilter poolDraftQFilter = new QFilter("billpool", ">", (Object)0);
        poolDraftQFilter.and("poollocktime", ">=", (Object)invalidDate);
        DynamicObject[] poolDrafts = BusinessDataServiceHelper.load((String)"cdm_pooldraftbill", (String)"id,poollocktime,poollockorg,poollockstatus", (QFilter[])new QFilter[]{poolDraftQFilter});
        if (poolDrafts.length == 0) {
            return;
        }
        for (DynamicObject poolDraft : poolDrafts) {
            poolDraft.set("poollockorg", null);
            poolDraft.set("poollockstatus", (Object)PoolLockStatusEnum.UNLOCK.getValue());
            poolDraft.set("poollocktime", null);
        }
        SaveServiceHelper.save((DynamicObject[])poolDrafts);
        logger.info("\u81ea\u52a8\u89e3\u9501\u7968\u636e\u6c60\u7968\u636e\u5904\u7406\u7ed3\u675f...");
    }
}

