/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillIntoPoolTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ReceivableBillIntoPoolTask.class);

    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        logger.info("\u5728\u624b\u5e94\u6536\u7968\u636e\u5230\u671f\u81ea\u52a8\u5165\u6c60\u626b\u63cf\u5f00\u59cb...");
        ArrayList<QFilter> tQFilterList = new ArrayList<QFilter>(0);
        tQFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        tQFilterList.add(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
        tQFilterList.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        tQFilterList.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        tQFilterList.add(new QFilter("isendorsepay", "=", (Object)"0"));
        tQFilterList.add(new QFilter("billpool", "=", (Object)0).or(QFilter.isNull((String)"billpool")));
        int tLastDay = 30;
        if (paramMap != null && !paramMap.isEmpty()) {
            Object lastday = paramMap.get("lastday");
            logger.info("\u53c2\u6570 lastday\uff1a" + lastday);
            if (EmptyUtil.isNoEmpty((Object)lastday)) {
                try {
                    tLastDay = Integer.parseInt(lastday.toString());
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
        Date today = DateUtils.getLastDay((Date)new Date(), (int)tLastDay);
        tQFilterList.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        DynamicObjectCollection receivablebill = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id", (QFilter[])tQFilterList.toArray(new QFilter[0]));
        if (receivablebill != null && receivablebill.size() > 0) {
            try {
                OperateOption operate = OperateOption.create();
                operate.setVariableValue("isMustInto", Boolean.TRUE.toString());
                TmcOperateServiceHelper.execOperate((String)"intopool", (String)"cdm_receivablebill", (Object[])receivablebill.stream().map(item -> item.getLong("id")).toArray(), (OperateOption)operate);
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        logger.info("\u5728\u624b\u5e94\u6536\u7968\u636e\u5230\u671f\u81ea\u52a8\u5165\u6c60\u5904\u7406\u7ed3\u675f...");
    }
}

