/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.task.elecdraft.NoteSignRejectAutoTask;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ElcDraftBackInfoSeriesCheckTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(NoteSignRejectAutoTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("ElcDraftBackInfoSeriesCheckTask start!");
        if (paramMap == null) {
            logger.info("ElcDraftBackInfoSeriesCheckTask start,paramMap empty,stop execute!");
            return;
        }
        Object seriesCheckTimes = paramMap.get("serieschecktimes");
        if (ObjectUtils.isNotEmpty((Object)seriesCheckTimes)) {
            QFilter eleRecQFilter = new QFilter("backinfoseries", "=", (Object)"0");
            eleRecQFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
            eleRecQFilter.and(new QFilter("serieschecktimes", "<", (Object)Integer.parseInt(seriesCheckTimes.toString())));
            Object seriesCheckDate = paramMap.get("seriescheckdate");
            if (ObjectUtils.isNotEmpty((Object)seriesCheckDate)) {
                eleRecQFilter.and(new QFilter("seriescheckdate", ">", (Object)DateUtils.stringToDate((String)seriesCheckDate.toString(), (String)"yyyy-MM-dd HH:mm:ss")));
            } else {
                eleRecQFilter.and(new QFilter("seriescheckdate", ">", (Object)DateUtils.stringToDate((String)"2023-05-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss")));
            }
            DynamicObject[] electRecBills = BusinessDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,serieschecktimes", (QFilter[])new QFilter[]{eleRecQFilter});
            logger.info("ElcDraftBackInfoSeriesCheckTask execute electRecBills.length = {}", (Object)electRecBills.length);
            if (electRecBills.length <= 0) {
                return;
            }
            Object[] pkIds = Arrays.stream(electRecBills).map(e -> e.getLong("id")).toArray();
            logger.info("ElcDraftBackInfoSeriesCheckTask execute lectRecBills.pkIds = {}", (Object)Arrays.toString(pkIds));
            OperateOption option = OperateOption.create();
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"draftinfoupdate", (String)"cdm_electronic_rec_deal", (Object[])pkIds, (OperateOption)option);
            logger.info("ElcDraftBackInfoSeriesCheckTask execute electRecBills.operationResult = {}", (Object)operationResult.isSuccess());
            if (operationResult.isSuccess()) {
                for (DynamicObject electRecBill : electRecBills) {
                    electRecBill.set("serieschecktimes", (Object)(electRecBill.getInt("serieschecktimes") + 1));
                }
                SaveServiceHelper.save((DynamicObject[])electRecBills);
            }
        } else {
            logger.info("ElcDraftBackInfoSeriesCheckTask execute serieschecktimes empty");
        }
        logger.info("ElcDraftBackInfoSeriesCheckTask execute end");
    }
}

