/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class ElcDraftSubRangeDataCheck
implements FIDataCheckTask {
    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        ElcDraftSubRangeDataCheck.checkSubRangeData();
        return true;
    }

    private static void checkSubRangeData() {
        String sql = "select a.fbillno billno,a.fdraftbillno,a.fsubbillrange,b.fsubrange,a.famount,a.fcompanyid from t_cdm_draftbill a left join t_cdm_electronicbill_f b on a.fsourcebillid = b.fid and a.fsubbillrange != b.fsubrange where a.fsubbillrange != ' ' and b.fsubrange != ' ' and a.fsubbillrange is not null and b.fsubrange != '' order by a.fcompanyid";
        DataSet electronicRecDealDataSet2 = DB.queryDataSet((String)"electronicRecDeal", (DBRoute)DBRouteConst.TMC, (String)sql);
        HashSet<String> notSameList = new HashSet<String>();
        for (Row row : electronicRecDealDataSet2.copy()) {
            String billNo = row.getString("billno");
            notSameList.add(billNo);
        }
        if (notSameList.size() > 0) {
            String billStr = notSameList.parallelStream().collect(Collectors.joining(","));
            String msg = String.format(ResManager.loadKDString((String)"\u7535\u7968\u5b50\u7968\u533a\u95f4\u4e0e\u5e94\u6536\u7968\u636e\u5b50\u7968\u533a\u95f4\u662f\u5426\u4e00\u81f4\u6570\u636e\u68c0\u67e5\uff0c\u5b58\u5728\u4e0d\u4e00\u81f4\u6570\u636e\u3010%1$s\u3011\uff0c\u6570\u91cf\u4e3a\u3010%2$s\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ElcDraftSubRangeDataCheck_1", (String)"fi-cas-business", (Object[])new Object[0]), billStr, notSameList.size());
            FIDataCheckUtil.saveResult((String)"elc_draft_subrange_data_check", (String)"cdm", (boolean)false, (String)msg, (String)"kd.tmc.cdm.business.task.elecdraft.ElcDraftSubRangeDataCheck");
        }
    }
}

