/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class QueryNoteReceivableAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(QueryNoteReceivableAutoTask.class);
    private static final List<String> EB_STATUS = Arrays.asList("BANK_PROCESSING", "EB_PROCESSING", "BANK_EXCEPTION", "BANK_UNKNOWN");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u4efb\u52a1\u5f00\u59cb");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterList.add(new QFilter("datasource", "=", (Object)"bank"));
        qFilterList.add(new QFilter("ebstatus", "in", EB_STATUS));
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObject[] queryBills = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        logger.info("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u6267\u884c\u6570\u636equeryBills.length={}", (Object)queryBills.length);
        if (queryBills.length > 0) {
            Object[] pkValues = Arrays.stream(queryBills).map(DataEntityBase::getPkValue).toArray();
            logger.info("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u6267\u884c\u6570\u636eid={}", (Object)Arrays.toString(pkValues));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"querynotereceivable", (String)"cdm_electronic_sign_deal", (Object[])pkValues, (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                logger.info(String.format("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a%s", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult)));
                throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
            }
            logger.info("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u6210\u529fid={}", (Object)operationResult.getSuccessPkIds().toString());
            logger.info("\u7535\u7968\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c(\u5e94\u6536\u7535\u7968)\u6267\u884c\u4efb\u52a1\u7ed3\u675f");
        }
    }
}

