/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.trade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.enums.GuaranteeTradeTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayDraftUnGuaranteeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PayDraftUnGuaranteeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u5f00\u59cb\u6267\u884c\uff01");
        long start = System.currentTimeMillis();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilters.add(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilters.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        qFilters.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
        Date today = new Date();
        qFilters.add(new QFilter("draftbillexpiredate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        qFilters.add(new QFilter("draftbillexpiredate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        qFilters.add(new QFilter("guarantflag", "=", (Object)"1"));
        Object[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (EmptyUtil.isNoEmpty((Object[])payableBills)) {
            Set billIdSet = Arrays.stream(payableBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            Object[] guaranteeBills = TmcDataServiceHelper.load((String)"cdm_guarantee_discount", (String)"id,billentries,billentries.draftbill", (QFilter[])new QFilter[]{new QFilter("billentries.draftbill.id", "in", billIdSet), new QFilter("biztype", "=", (Object)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue()), new QFilter("billstatus", "!=", (Object)"C")});
            if (EmptyUtil.isNoEmpty((Object[])guaranteeBills)) {
                LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u5df2\u5b58\u5728\u90e8\u5206\u7968\u636e\u5173\u8054\u672a\u5ba1\u6838\u7684\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u7684\u7968\u636e!");
                Arrays.stream(guaranteeBills).forEach(bill -> {
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentries");
                    entries.forEach(e -> billIdSet.remove(e.getDynamicObject("draftbill").getPkValue()));
                });
                LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u79fb\u9664\u5df2\u5173\u8054\u672a\u5ba1\u6838\u7684\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u7684\u7968\u636e\u4e4b\u540e\u7684\u7968\u636eid\u96c6\u5408\uff1a{}", billIdSet);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("biztype", GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"autoguarantee", (String)"cdm_payablebill", (Object[])billIdSet.toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u5e94\u4ed8\u7968\u636e\u4e0b\u63a8\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)operationResult.getMessage());
            } else {
                QFilter qFilter = new QFilter("billentries.draftbill.id", "in", billIdSet);
                qFilter.and(new QFilter("biztype", "=", (Object)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue()));
                qFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
                guaranteeBills = TmcDataServiceHelper.load((String)"cdm_guarantee_discount", (String)"id", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((Object[])guaranteeBills) && !(operationResult = OperateServiceHelper.execOperate((String)"audit", (String)"cdm_guarantee_discount", (Object[])Arrays.stream(guaranteeBills).map(DataEntityBase::getPkValue).distinct().toArray(), (OperateOption)OperateOption.create())).isSuccess()) {
                    LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u5e94\u4ed8\u7968\u636e\u4e0b\u63a8\u7684\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)operationResult.getMessage());
                }
            }
        }
        LOGGER.info("[\u5e94\u4ed8\u7968\u636e\u5230\u671f\u540e\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0]\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }
}

