/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.allocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.TransStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class DraftAllocationFailCancelValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("e_transstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map variables = this.getOption().getVariables();
        List selectRowIds = (List)SerializationUtils.fromJsonString((String)((String)variables.get("selectRowIds")), List.class);
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        DynamicObject draftAllocation = extendedDataEntity.getDataEntity();
        if (CollectionUtils.isEmpty((Collection)selectRowIds)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea4\u6613\u5931\u8d25\u7684\u660e\u7ec6\u3002", (String)"DraftAllocationFailCancelValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryEntity = draftAllocation.getDynamicObjectCollection("entryentity");
        ArrayList<Object> entryIds = new ArrayList<Object>(entryEntity.size());
        for (DynamicObject row : entryEntity) {
            for (Object selectRowId : selectRowIds) {
                if (!row.getPkValue().equals(selectRowId)) continue;
                entryIds.add(row.getPkValue());
                if (Objects.equals(row.get("e_transstatus"), TransStatusEnum.FAILED.getValue())) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u4ea4\u6613\u5931\u8d25\u7684\u660e\u7ec6\u8bb0\u5f55\u624d\u53ef\u4ee5\u70b9\u51fb\u5931\u8d25\u4f5c\u5e9f\u3002", (String)"DraftAllocationFailCancelValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        if (!CollectionUtils.isEmpty(entryIds)) {
            this.checkReceivableBills(extendedDataEntity, entryIds);
            this.checkDraftTradeBills(extendedDataEntity, entryIds, entryEntity);
        }
    }

    private void checkDraftTradeBills(ExtendedDataEntity extendedDataEntity, List<Object> entryIds, DynamicObjectCollection entryEntity) {
        DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"allocbillentryid", (QFilter[])new QFilter("allocbillentryid", "in", entryIds).toArray());
        if (draftTradeBills != null && draftTradeBills.length > 0) {
            for (DynamicObject draftTradeBill : draftTradeBills) {
                for (DynamicObject row : entryEntity) {
                    if (!Objects.equals(draftTradeBill.get("allocbillentryid"), row.getPkValue())) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e%s\u5df2\u5b58\u5728\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u4e0d\u80fd\u4f5c\u5e9f\uff0c\u8bf7\u5c1d\u8bd5\u5931\u8d25\u91cd\u53d1\u3002", (String)"DraftAllocationFailCancelValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), row.getDynamicObject("e_draftbill").get("draftbillno")));
                }
            }
        }
    }

    private void checkReceivableBills(ExtendedDataEntity extendedDataEntity, List<Object> entryIds) {
        DynamicObject[] loadReceivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"draftbillno", (QFilter[])new QFilter("allocbillentryid", "in", entryIds).toArray());
        if (loadReceivableBills != null && loadReceivableBills.length > 0) {
            String draftBillNos = Arrays.stream(loadReceivableBills).map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e%s\u5df2\u5b58\u5728\u4e0b\u6e38\u5e94\u6536\u7968\u636e\uff0c\u4e0d\u80fd\u4f5c\u5e9f\uff0c\u8bf7\u5c1d\u8bd5\u5931\u8d25\u91cd\u53d1\u3002", (String)"DraftAllocationFailCancelValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillNos));
        }
    }
}

