/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDraftsDeleteValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(BankDraftsDeleteValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("bankaccount");
        selector.add("org");
        selector.add("biztype");
        selector.add("datadate");
        selector.add("bankdraftentry");
        selector.add("e_checkstatus");
        selector.add("e_inventorystatus");
        selector.add("e_subbillendflag");
        selector.add("e_subbillstartflag");
        selector.add("e_subbillrange");
        selector.add("e_issplit");
        selector.add("e_draftamount");
        selector.add("e_datasource");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject bankAccount = data.getDynamicObject("bankaccount");
            String bankName = bankAccount.getString("name");
            Date dataDate = data.getDate("datadate");
            String dateStr = DateUtils.formatString((Date)dataDate, (String)"yyyy-MM-dd");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("bankdraftentry");
            Set chekedDataSet = entrys.stream().filter(e -> "B".equalsIgnoreCase(e.getString("e_inventorystatus"))).collect(Collectors.toSet());
            if (!EmptyUtil.isNoEmpty(chekedDataSet) || chekedDataSet.size() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7: %1$s \uff0c \u6570\u636e\u65e5\u671f\uff1a%2$s\uff0c\u7968\u636e\u76d8\u70b9\u7ed3\u679c\u5df2\u5305\u542b\u8be5\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5728\u5546\u4e1a\u6c47\u7968\u76d8\u70b9\u529f\u80fd\u5185\u53d6\u6d88\u76d8\u70b9\u540e\u518d\u8bd5\u3002", (String)"BankDraftsDeleteValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), bankName, dateStr));
        }
    }
}

