/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDraftsSaveValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(BankDraftsSaveValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("bankaccount");
        selector.add("org");
        selector.add("biztype");
        selector.add("datadate");
        selector.add("bankdraftentry");
        selector.add("e_checkstatus");
        selector.add("e_inventorystatus");
        selector.add("e_subbillendflag");
        selector.add("e_subbillstartflag");
        selector.add("e_subbillrange");
        selector.add("e_issplit");
        selector.add("e_draftamount");
        selector.add("e_datasource");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DynamicObjectCollection bankDraftsDb;
        Set hasMatchRepeatDataSet;
        DynamicObjectCollection bankDraftsFromDb;
        HashSet<Date> dataDateList = new HashSet<Date>(16);
        HashSet<Long> bankAccIdList = new HashSet<Long>(16);
        HashSet<String> bankAccidAndDateKeySet = new HashSet<String>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject bankAccount = data.getDynamicObject("bankaccount");
            long bankAccId = bankAccount.getLong("id");
            Date dataDate = data.getDate("datadate");
            String dateStr = DateUtils.formatString((Date)dataDate, (String)"yyyy-MM-dd");
            String keyStr = bankAccId + "_" + dateStr;
            if (bankAccidAndDateKeySet.contains(keyStr)) continue;
            bankAccidAndDateKeySet.add(keyStr);
            dataDateList.add(dataDate);
            bankAccIdList.add(bankAccId);
        }
        if (EmptyUtil.isNoEmpty(dataDateList) && EmptyUtil.isNoEmpty(bankAccIdList) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(bankDraftsFromDb = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate", (QFilter[])new QFilter[]{new QFilter("bankaccount", "in", bankAccIdList), new QFilter("datadate", "in", dataDateList)}))) && EmptyUtil.isNoEmpty(hasMatchRepeatDataSet = bankDraftsFromDb.stream().filter(e -> bankAccidAndDateKeySet.contains(e.getLong("bankaccount") + "_" + DateUtils.formatString((Date)e.getDate("datadate"), (String)"yyyy-MM-dd"))).map(e -> e.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(bankDraftsDb = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate,bankdraftentry.e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", hasMatchRepeatDataSet), new QFilter("bankdraftentry.e_inventorystatus", "=", (Object)"B")})))) {
            Set repeatDatas = bankDraftsDb.stream().map(e -> e.getLong("bankaccount") + "_" + DateUtils.formatString((Date)e.getDate("datadate"), (String)"yyyy-MM-dd")).collect(Collectors.toSet());
            for (ExtendedDataEntity extendedDataEntity : dataEntity) {
                DynamicObject data = extendedDataEntity.getDataEntity();
                DynamicObject bankAccount = data.getDynamicObject("bankaccount");
                long bankAccId = bankAccount.getLong("id");
                String bankAccName = bankAccount.getString("name");
                Date dataDate = data.getDate("datadate");
                String dateStr = DateUtils.formatString((Date)dataDate, (String)"yyyy-MM-dd");
                String keyStr = bankAccId + "_" + dateStr;
                if (!repeatDatas.contains(keyStr)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u65e5\u671f\uff1a%1$s, \u94f6\u884c\u8d26\u6237\uff1a%2$s\uff1a\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4\u5df2\u76d8\u70b9\u7684\u6570\u636e\u3002", (String)"BankDraftsSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), dateStr, bankAccName));
            }
        }
    }
}

