/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CancelAuditInventoryValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(CancelAuditInventoryValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("draftinventoryreport");
        selector.add("draftinventoryreportid");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        logger.info("process is start");
        HashSet<Long> needDeleteInventoryResultSet = new HashSet<Long>(16);
        HashMap<Long, ExtendedDataEntity> map = new HashMap<Long, ExtendedDataEntity>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject chequeInventoryDy = extendedDataEntity.getDataEntity();
            long draftinventoryReportid = chequeInventoryDy.getLong("draftinventoryreportid");
            if (!EmptyUtil.isNoEmpty((Long)draftinventoryReportid)) continue;
            needDeleteInventoryResultSet.add(draftinventoryReportid);
            map.put(draftinventoryReportid, extendedDataEntity);
        }
        DynamicObjectCollection inventoryResultColl = QueryServiceHelper.query((String)"cdm_inventoryresult", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", needDeleteInventoryResultSet)});
        for (DynamicObject inventoryResult : inventoryResultColl) {
            String billstatus = inventoryResult.getString("billstatus");
            if ("A".equals(billstatus)) continue;
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)map.get(inventoryResult.getLong("id"));
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u6570\u636e\u5bf9\u5e94\u7684\u76d8\u70b9\u8868\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"CancelAuditInventoryValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

