/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GenDraftsByInventoryValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(GenDraftsByInventoryValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Set ncd_bankDraftIdSet;
            DynamicObject[] ncdBankDraftsArr;
            Set<Long> eleDraftIdSet;
            DynamicObjectCollection queryEleDraft;
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObjectCollection bank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)bank_ncd_entryentity) || bank_ncd_entryentity.size() <= 0 || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(queryEleDraft = QueryServiceHelper.query((String)"cdm_electronic_rec_deal", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(eleDraftIdSet = Arrays.stream(ncdBankDraftsArr = BusinessDataServiceHelper.load((String)"cdm_bankdraftdatasf7", (String)"id,gendraftbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(ncd_bankDraftIdSet = bank_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_bankdraft").getLong("id")).collect(Collectors.toSet())).toArray())})).filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("gendraftbillid"))).map(e -> e.getLong("gendraftbillid")).collect(Collectors.toSet())).toArray(new Long[0]))})))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u5bf9\u5e94\u7684\u672a\u6838\u5bf9\u7684\u94f6\u884c\u6570\u636e\u5df2\u7ecf\u751f\u6210\u4e86\u5bf9\u5e94\u7684\u53f8\u5e93\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"GenDraftsByInventoryValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

