/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QuecheCancelInventoryValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(QuecheCancelInventoryValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("isbybankaccount");
        selector.add("isinventoryfilled");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("filledacutaiamount");
        selector.add("filledchequeamount");
        selector.add("blankactualcount");
        selector.add("blankchequecount");
        selector.add("filledactualcount");
        selector.add("filledchequecount");
        selector.add("blankactual_ncd_entry");
        selector.add("blankactual_ncd_entry.e_ncd_blankactual");
        selector.add("blankcheque_ncd_entry");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheque");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheckstatus");
        selector.add("blankactual_cd_entry");
        selector.add("blankactual_cd_entry.e_cd_blankactualdraft");
        selector.add("blankcheque_cd_entry");
        selector.add("blankcheque_cd_entry.e_cd_blankcheque");
        selector.add("blankcheque_cd_entry.e_cd_blankcheckstatus");
        selector.add("filledactual_ncd_entry");
        selector.add("filledactual_ncd_entry.e_ncd_fiillactual");
        selector.add("filled_ncdcheque_entry");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheque");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheckstatus");
        selector.add("filledactual_cd_entry");
        selector.add("filledactual_cd_entry.e_cd_filledactual");
        selector.add("filled_cd_chequeentry");
        selector.add("filled_cd_chequeentry.e_cd_fillcheque");
        selector.add("filled_cd_chequeentry.e_cd_fillcheckstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            boolean isInventoryFilled = data.getBoolean("isinventoryfilled");
            DynamicObjectCollection blankActual_cd_entryentity = data.getDynamicObjectCollection("blankactual_cd_entry");
            DynamicObjectCollection blankCheque_cd_entryentity = data.getDynamicObjectCollection("blankcheque_cd_entry");
            boolean isNoCdData = false;
            if (EmptyUtil.isEmpty((DynamicObjectCollection)blankActual_cd_entryentity) && EmptyUtil.isEmpty((DynamicObjectCollection)blankCheque_cd_entryentity)) {
                isNoCdData = true;
            }
            if (isInventoryFilled) {
                DynamicObjectCollection fillActual_cd_entryentity = data.getDynamicObjectCollection("filledactual_cd_entry");
                DynamicObjectCollection fillCheque_cd_entryentity = data.getDynamicObjectCollection("filledactual_ncd_entry");
                isNoCdData = EmptyUtil.isEmpty((DynamicObjectCollection)fillActual_cd_entryentity) && EmptyUtil.isEmpty((DynamicObjectCollection)fillCheque_cd_entryentity);
            }
            if (!isNoCdData) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u5df2\u6838\u5bf9\u7684\u6570\u636e\u3002", (String)"QuecheCancelInventoryValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

