/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.basedata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class EleNoticeRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(8);
        sic.add("rule_entity");
        sic.add("org_entry");
        sic.add("e_handlescheme");
        sic.add("e_rulesname");
        sic.add("org_entry.u_org");
        sic.add("rule_entity.e_handlescheme");
        sic.add("rule_entity.e_savenotifi");
        sic.add("rule_entity.e_refuseremark");
        sic.add("rule_entity.e_datafilterdesc");
        sic.add("rule_entity.e_notifische");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"EleNoticeRuleSaveValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject allOrgDatum;
            boolean isSelf;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection ruleEntities = dataEntity.getDynamicObjectCollection("rule_entity");
            DynamicObjectCollection orgEntry = dataEntity.getDynamicObjectCollection("org_entry");
            Long id = dataEntity.getLong("id");
            if (ruleEntities.size() > 0) {
                for (int i = 0; i < ruleEntities.size(); ++i) {
                    String handleScheme = ((DynamicObject)ruleEntities.get(i)).getString("e_handlescheme");
                    String refuseRemark = ((DynamicObject)ruleEntities.get(i)).getString("e_refuseremark");
                    String string = ((DynamicObject)ruleEntities.get(i)).getString("e_notifische");
                    if ("notesigninreject".equals(handleScheme) && StringUtils.isEmpty((CharSequence)refuseRemark)) {
                        this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u62d2\u6536\u64cd\u4f5c\u8981\u6c42\u62d2\u6536\u610f\u89c1\u5fc5\u586b", (String)"EleNoticeRuleSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    }
                    if (!"noticeclaim".equals(handleScheme) || !StringUtils.isEmpty((CharSequence)string)) continue;
                    this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u901a\u77e5\u8ba4\u9886\u8981\u6c42\u901a\u77e5\u65b9\u6848\u5fc5\u586b", (String)"EleNoticeRuleSaveValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                }
            }
            if (orgEntry.size() > 0) {
                Map<Object, List<DynamicObject>> currOrgEntryMap = orgEntry.stream().collect(Collectors.groupingBy(e -> e.get("u_org.id")));
                HashSet<String> selfReOrgName = new HashSet<String>(currOrgEntryMap.size());
                for (Map.Entry entry : currOrgEntryMap.entrySet()) {
                    List value = (List)entry.getValue();
                    if (value.size() <= 1) continue;
                    selfReOrgName.add(((DynamicObject)value.get(0)).getString("u_org.name"));
                }
                if (selfReOrgName.size() > 0) {
                    this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7(%s)\u91cd\u590d", (String)"EleNoticeRuleSaveValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), String.join((CharSequence)",", selfReOrgName)), ErrorLevel.Error);
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
                if (!Long.valueOf("0").equals(id)) {
                    qFilterList.add(new QFilter("id", "!=", (Object)id));
                }
                List list = orgEntry.stream().map(e -> e.get("u_org.id")).collect(Collectors.toList());
                qFilterList.add(new QFilter("org_entry.u_org.id", "in", list));
                qFilterList.add(new QFilter("enable", "=", (Object)true));
                DynamicObject[] existData = TmcDataServiceHelper.load((String)"cdm_ele_notice_rule", (String)"u_org", (QFilter[])qFilterList.toArray(new QFilter[0]));
                if (existData.length <= 0) continue;
                HashSet existOrgNameSet = new HashSet(8);
                for (DynamicObject existDatum : existData) {
                    DynamicObjectCollection entryEntity = existDatum.getDynamicObjectCollection("org_entry");
                    existOrgNameSet.addAll(entryEntity.stream().map(e -> e.getString("u_org.name")).collect(Collectors.toSet()));
                }
                String existOrgNameS = String.join((CharSequence)",", existOrgNameSet);
                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u5b58\u5728\u6709\u6548\u7684\u89c4\u5219\uff0c\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4", (String)"EleNoticeRuleSaveValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), existOrgNameS), ErrorLevel.Error);
                continue;
            }
            DynamicObject[] allOrgData = TmcDataServiceHelper.load((String)"cdm_ele_notice_rule", (String)"id", (QFilter[])new QFilter[]{QFilter.isNull((String)"org_entry")});
            if (allOrgData.length <= 0 || (isSelf = (allOrgDatum = allOrgData[0]).get("id").equals(id))) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5168\u90e8\u7ec4\u7ec7\u9002\u7528\u7684\u89c4\u5219\uff0c\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4", (String)"EleNoticeRuleSaveValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

