/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.billpool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillPoolTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;

public class BillPoolSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject billPool = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = billPool.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6c60\u6210\u5458\u5217\u8868\u81f3\u5c11\u6709\u4e00\u4e2a\u6c60\u6210\u5458\u3002", (String)"BillPoolSaveValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            DynamicObject billPoolByName = BusinessDataServiceHelper.loadSingleFromCache((String)"cdm_billpool", (QFilter[])new QFilter("name", "=", (Object)billPool.getLocaleString("name").getLocaleValue()).toArray());
            if (billPoolByName != null && !Objects.equals(billPool.getPkValue(), billPoolByName.getPkValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u7968\u636e\u6c60\u3002", (String)"BillPoolSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), billPool.get("name")));
            }
            this.checkByType(extendedDataEntity, this.getQFilters(billPool));
        }
    }

    private QFilter[] getQFilters(DynamicObject billPool) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        QFilter typeFilter = new QFilter("type", "=", billPool.get("type"));
        QFilter idFilter = new QFilter("id", "!=", billPool.getPkValue());
        QFilter qFilters = enableFilter.and(typeFilter).and(idFilter);
        if (Objects.equals(billPool.get("type"), BillPoolTypeEnum.BANK.getValue())) {
            qFilters.and(new QFilter("bank", "=", billPool.getDynamicObject("bank").getPkValue()));
        }
        return qFilters.toArray();
    }

    private void checkByType(ExtendedDataEntity extendedDataEntity, QFilter[] qFilters) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)String.join((CharSequence)",", "name", "company", "entryentity.e_company"), (QFilter[])qFilters);
        DynamicObject billPool = extendedDataEntity.getDataEntity();
        Set<DynamicObject> currSaveBillCompanySet = this.getCompanySet(billPool);
        for (DynamicObject innerBillPool : billPools) {
            Set<DynamicObject> billCompanySet = this.getCompanySet(innerBillPool);
            Set<DynamicObject> intersectCompanySet = this.intersect(currSaveBillCompanySet, billCompanySet);
            if (CollectionUtils.isEmpty(intersectCompanySet)) continue;
            this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(innerBillPool, intersectCompanySet));
        }
    }

    private String buildErrorMessage(DynamicObject innerBillPool, Set<DynamicObject> intersectCompanySet) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject company : intersectCompanySet) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7968\u636e\u6c60\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4\u3002", (String)"BillPoolSaveValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), innerBillPool.get("name"), company.get("name")));
        }
        return sb.toString();
    }

    private Set<DynamicObject> intersect(Set<DynamicObject> currSaveBillCompanySet, Set<DynamicObject> billCompanySet) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>();
        for (DynamicObject currSaveCompany : currSaveBillCompanySet) {
            for (DynamicObject billCompany : billCompanySet) {
                if (!Objects.equals(currSaveCompany.getPkValue(), billCompany.getPkValue())) continue;
                set.add(billCompany);
            }
        }
        return set;
    }

    private Set<DynamicObject> getCompanySet(DynamicObject innerBillPool) {
        DynamicObjectCollection entry = innerBillPool.getDynamicObjectCollection("entryentity");
        Set<DynamicObject> companySet = entry.stream().map(e -> e.getDynamicObject("e_company")).filter(Objects::nonNull).collect(Collectors.toSet());
        companySet.add(innerBillPool.getDynamicObject("company"));
        return companySet;
    }
}

