/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.billpoolbiz;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolBizAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("businesstype");
        selector.add("billpool");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject billPoolBiz = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = billPoolBiz.getDynamicObjectCollection("entryentity");
            this.checkDraftBills(extendedDataEntity, billPoolBiz, entryEntity);
        }
    }

    private void checkDraftBills(ExtendedDataEntity extendedDataEntity, DynamicObject billPoolBiz, DynamicObjectCollection entryEntity) {
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject draftBill = dynamicObject.getDynamicObject("e_draftbill");
            if (!Objects.nonNull(draftBill)) continue;
            if (Objects.equals(billPoolBiz.get("businesstype"), BizBusinessTypeEnum.JOIN.getValue())) {
                this.checkJoin(extendedDataEntity, billPoolBiz, draftBill);
                continue;
            }
            this.checkOut(extendedDataEntity, billPoolBiz, draftBill);
        }
    }

    private void checkOut(ExtendedDataEntity extendedDataEntity, DynamicObject billPoolBiz, DynamicObject draftBill) {
        DynamicObject draftBillFromDB = BusinessDataServiceHelper.loadSingle((Object)draftBill.getPkValue(), (String)"cdm_draftbillf7");
        DynamicObject entryBillPool = draftBillFromDB.getDynamicObject("billpool");
        DynamicObject headBillPool = billPoolBiz.getDynamicObject("billpool");
        if (Objects.isNull(entryBillPool) || !Objects.equals(entryBillPool.getPkValue(), headBillPool.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u5df2\u7ecf\u4e0d\u5728\u7968\u636e\u6c60\u201c%2$s\u201d\u4e2d\u3002", (String)"BillPoolAuditValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.get("draftbillno"), headBillPool.get("name")));
        }
    }

    private void checkJoin(ExtendedDataEntity extendedDataEntity, DynamicObject billPoolBiz, DynamicObject draftBill) {
        DynamicObject headBillPool;
        DynamicObject draftBillFromDB = BusinessDataServiceHelper.loadSingle((Object)draftBill.getPkValue(), (String)"cdm_draftbillf7");
        DynamicObject billPool = draftBillFromDB.getDynamicObject("billpool");
        if (Objects.nonNull(billPool) && EmptyUtil.isNoEmpty((DynamicObject)(headBillPool = billPoolBiz.getDynamicObject("billpool"))) && !Objects.equals(billPool.getPkValue(), headBillPool.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u5df2\u7ecf\u5728\u7968\u636e\u6c60\u201c%2$s\u201d\u4e2d\u3002", (String)"BillPoolAuditValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.get("draftbillno"), billPool.get("name")));
        }
    }
}

