/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.billpoolbiz;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.PoolLockOperateTypeEnum;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class PoolDraftLockValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("poollockstatus");
        selector.add("billpool");
        selector.add("draftbillno");
        selector.add("poollockorg");
        selector.add("poollocktime");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject[] lockRules;
            boolean isEquals;
            DynamicObject poolDraft = extendedDataEntity.getDataEntity();
            String poolLockStatus = poolDraft.getString("poollockstatus");
            if (poolLockStatus.equals(PoolLockStatusEnum.LOCK.getValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u3010%s\u3011\u5df2\u7ecf\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u3002", (String)"PoolDraftLockValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), poolDraft.get("draftbillno")));
            }
            DynamicObject billPool = BusinessDataServiceHelper.loadSingle((Object)poolDraft.getDynamicObject("billpool").getPkValue(), (String)"cdm_billpool");
            DynamicObjectCollection billPoolEntity = billPool.getDynamicObjectCollection("entryentity");
            DynamicObject lockBillUser = poolDraft.getDynamicObject("poollockorg");
            boolean isExist = billPoolEntity.stream().anyMatch(a -> Long.parseLong(a.getDynamicObject("e_company").getPkValue().toString()) == lockBillUser.getLong("id"));
            boolean bl = isEquals = Long.parseLong(billPool.getDynamicObject("company").getPkValue().toString()) == lockBillUser.getLong("id");
            if (!isExist && !isEquals) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u52a0\u9501\u7684\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u5c5e\u4e8e\u8be5\u7968\u636e\u6c60\uff0c\u4e0d\u80fd\u5bf9\u6c60\u5185\u7968\u636e\u52a0\u9501\u3002", (String)"PoolDraftLockValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if ((lockRules = BusinessDataServiceHelper.load((String)"cdm_lockrule", (String)"locktimeslimit,maxlocktimes,lockamountlimit,maxlockamount", null)).length == 0) continue;
            DynamicObject lockRule = lockRules[0];
            if (lockRule.getBoolean("locktimeslimit")) {
                int maxLockTimes = lockRule.getInt("maxlocktimes");
                QFilter maxLockTimesQFilter = new QFilter("pooldraft", "=", poolDraft.getPkValue());
                maxLockTimesQFilter.and(new QFilter("poollockorg", "=", lockBillUser.getPkValue()));
                maxLockTimesQFilter.and(new QFilter("operatetype", "=", (Object)PoolLockOperateTypeEnum.LOCK.getValue()));
                DynamicObject[] lockTimeDy = BusinessDataServiceHelper.load((String)"cdm_pooldraft_log", (String)"id", (QFilter[])new QFilter[]{maxLockTimesQFilter});
                if (lockTimeDy.length >= maxLockTimes) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u5df2\u8fbe\u6700\u5927\u9501\u5b9a\u6b21\u6570\u9650\u5236\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u9501\u5b9a\u3002", (String)"PoolDraftLockValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), poolDraft.get("draftbillno")));
                }
            }
            if (!lockRule.getBoolean("lockamountlimit")) continue;
            int maxLockAmount = lockRule.getInt("maxlockamount");
            QFilter maxLockAmountQFilter = new QFilter("poollockorg", "=", lockBillUser.getPkValue());
            maxLockAmountQFilter.and(new QFilter("billpool", "is not null", null).and(new QFilter("billpool", ">", (Object)0)));
            DynamicObject[] maxLockAmountDy = BusinessDataServiceHelper.load((String)"cdm_pooldraftbill", (String)"id", (QFilter[])new QFilter[]{maxLockAmountQFilter});
            if (maxLockAmountDy.length < maxLockAmount) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u5904\u4e8e\u9501\u5b9a\u7684\u7968\u636e\u5f20\u6570\u8d85\u8fc7\u6700\u5927\u503c\u9650\u5236\uff0c\u65e0\u6cd5\u9501\u5b9a\u65b0\u7684\u7968\u636e\u3002", (String)"PoolDraftLockValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

