/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.billpoolbiz;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class PoolDraftUnlockValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("poollockstatus");
        selector.add("billpool");
        selector.add("draftbillno");
        selector.add("poollockorg");
        selector.add("poollocktime");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject poolDraft = extendedDataEntity.getDataEntity();
            String poolLockStatus = poolDraft.getString("poollockstatus");
            if (poolLockStatus.equals(PoolLockStatusEnum.UNLOCK.getValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u672a\u9501\u5b9a\uff0c\u4e0d\u9700\u8981\u89e3\u9501\u64cd\u4f5c\u3002", (String)"PoolDraftUnlockValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), poolDraft.get("draftbillno")));
            }
            long poolLockOrg = poolDraft.getDynamicObject("poollockorg") == null ? 0L : Long.parseLong(poolDraft.getDynamicObject("poollockorg").getPkValue().toString());
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"cdm", (String)"cdm_pooldraftbill", (String)"47150e89000000ac");
            if (authOrgList.contains(poolLockOrg)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u6743\u5bf9\u6c60\u5185\u7968\u636e\u89e3\u9501\u3002", (String)"PoolDraftUnlockValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

