/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElcDraftModifyEbStatusValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("ebstatus");
        sic.add("backflag");
        sic.add("billno");
        sic.add("tradetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List idList = Arrays.stream(extendedDataEntities).map(elcDraft -> elcDraft.getDataEntity().getPkValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.billsourceid", "in", idList);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        HashSet existSourceIdSet = new HashSet(10);
        Object[] modifyStatusBillList = TmcDataServiceHelper.load((String)"cdm_ebstatuschange", (String)"id,entryentity,entryentity.billsourceid", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])modifyStatusBillList)) {
            Arrays.stream(modifyStatusBillList).forEach(modifyStatusBill -> {
                DynamicObjectCollection entries = modifyStatusBill.getDynamicObjectCollection("entryentity");
                entries.forEach(e -> existSourceIdSet.add(e.get("billsourceid")));
            });
        }
        HashSet<String> tradeTypeSet = new HashSet<String>(10);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ebStatus = dataEntity.getString("ebstatus");
            if (!("EB_PROCESSING".equals(ebStatus) || "BANK_EXCEPTION".equals(ebStatus) || "BANK_UNKNOWN".equals(ebStatus) || "BANK_FAIL".equals(ebStatus))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u4ea4\u6613\u672a\u786e\u8ba4\u201d\u3001\u201c\u94f6\u4f01\u5904\u7406\u4e2d\u201d\u548c\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u8bb0\u5f55\u53d8\u66f4\u3002", (String)"ElcDraftModifyEbStatusValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            String isBack = dataEntity.getString("backflag");
            if ("1".equals(isBack)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u7968\u636e\u65e0\u6cd5\u53d1\u8d77\u7535\u7968\u64cd\u4f5c\u72b6\u6001\u53d8\u66f4\u3002", (String)"ElcDraftModifyEbStatusValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (existSourceIdSet.contains(dataEntity.getPkValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"%s\u7968\u636e\u7684\u64cd\u4f5c\u72b6\u6001\u6b63\u5728\u53d8\u66f4\uff0c\u8bf7\u5b8c\u6210\u53d8\u66f4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ElcDraftModifyEbStatusValidator_3", (String)"tmc-cdm-business", (Object[])new Object[]{dataEntity.getString("billno")}));
            }
            tradeTypeSet.add(dataEntity.getString("tradetype"));
        }
        if (tradeTypeSet.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u540c\u4e00\u64cd\u4f5c\u7c7b\u578b\u7684\u7968\u636e\u6279\u91cf\u4fee\u6539\u7535\u7968\u64cd\u4f5c\u72b6\u6001\u3002", (String)"ElcDraftModifyEbStatusValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

