/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class EleDraftSignStorageValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("basedraftbillno");
        sic.add("sourcebillid");
        sic.add("ticketstatus");
        sic.add("backflag");
        sic.add("ebstatus");
        sic.add("datasource");
        sic.add("opstatus");
        sic.add("company");
        sic.add("notestatus");
        sic.add("cirstatus");
        sic.add("grdbag");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<Long, List<ExtendedDataEntity>> companyMaps = Arrays.stream(extendedDataEntities).collect(Collectors.groupingBy(o -> o.getDataEntity().getDynamicObject("company").getLong("id")));
        if (companyMaps.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u624b\u5de5\u5165\u5e93\u53ea\u5141\u8bb8\u540c\u8d44\u91d1\u7ec4\u7ec7\u6279\u91cf\u64cd\u4f5c", (String)"EleDraftSignStorageValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String isBack;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ticketStatus = dataEntity.getString("ticketstatus");
            String noteStatus = dataEntity.getString("notestatus");
            String cirStatus = dataEntity.getString("cirstatus");
            boolean grdBag = dataEntity.getBoolean("grdbag");
            if (grdBag) {
                if (EleDraftNoteStatusEnum.CS05.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0501.getValue().equals(cirStatus)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (String)"EleDraftSignStorageValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            } else {
                EleDraftBillStatusEnum ticStatusEnum = EleDraftBillStatusEnum.getByValue((String)ticketStatus);
                if (EleDraftBillStatusEnum.DESTROY.getValue().equals(ticketStatus)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (String)"EleDraftSignStorageValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (EleDraftBillStatusEnum.INVOICE == ticStatusEnum || EleDraftBillStatusEnum.RECITE == ticStatusEnum || EleDraftBillStatusEnum.RELEASEPLEDGE == ticStatusEnum || EleDraftBillStatusEnum.ACCEPTANCE == ticStatusEnum || EleDraftBillStatusEnum.ENSURE == ticStatusEnum || EleDraftBillStatusEnum.NOTEDISCOUNT == ticStatusEnum || EleDraftBillStatusEnum.PLEDGE == ticStatusEnum || EleDraftBillStatusEnum.PAYMENT == ticStatusEnum || EleDraftBillStatusEnum.SEARCHFOR == ticStatusEnum || EleDraftBillStatusEnum.PROMISESEARCHFOR == ticStatusEnum) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7535\u7968\u72b6\u6001\u7684\u7968\u636e\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (String)"EleDraftSignStorageValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if (!"1".equals(isBack = dataEntity.getString("backflag"))) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u7968\u636e\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (String)"EleDraftSignStorageValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

