/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillApBatchSaveOrSubmitOpValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(PayableBillApBatchSaveOrSubmitOpValidator.class);
    private static final String ENTRY_ENTITY = "entryentity";

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(36);
        sic.add("billstatus");
        sic.add("company");
        sic.add("bizdate");
        sic.add("draftbilltype");
        sic.add("currency");
        sic.add("acceptercompany");
        sic.add("creditlimit");
        sic.add("creditamount");
        sic.add("billingtype");
        sic.add("amounttotal");
        sic.add("draftbilltype");
        sic.add(ENTRY_ENTITY);
        sic.add("entryentity.draweraccount");
        sic.add("entryentity.amount");
        sic.add("entryentity.issuedate");
        sic.add("entryentity.draftbillexpiredate");
        sic.add("entryentity.acceptercompany");
        sic.add("entryentity.invalid");
        sic.add("entryentity.drawercompany");
        sic.add("entryentity.receiver");
        sic.add("entryentity.receivername");
        sic.add("entryentity.receiverbank");
        sic.add("entryentity.draweraccount");
        sic.add("entryentity.drawerbankname");
        sic.add("entryentity.receiveraccount");
        sic.add("entryentity.payeetype");
        sic.add("entryentity.drawerorg");
        sic.add("entryentity.amount");
        sic.add("entryentity.entry_amountofcredit");
        sic.add("entry_gcontract");
        sic.add("entry_gcontract.gcontract");
        sic.add("entry_gcontract.gcreditguarantee");
        sic.add("entry_gcontract.gamount");
        sic.add("entry_gcontract.gratio");
        sic.add("entry_gcontract.gcontractamount");
        sic.add("entry_gcontract.gcontractcurrency");
        sic.add("entry_gcontract.gexchrate");
        sic.add("entry_gcontract.gcomment");
        sic.add("entry_gcontract.gsrcbillid");
        sic.add("entry_gcontract.gsrcbilltype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        logger.info("validate is start that:" + dataEntities.length);
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject payableApplyBillDO = dataEntity.getDataEntity();
            DynamicObjectCollection payablebillApplys = payableApplyBillDO.getDynamicObjectCollection(ENTRY_ENTITY);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)payablebillApplys)) {
                String message = String.format(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5f00\u7968\u7533\u8bf7\u660e\u7ec6\u884c\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), payableApplyBillDO.getString("billno"));
                this.addMessage(dataEntity, message, ErrorLevel.Error);
            }
            this.checkHeadFieldsMustInput(dataEntity);
            this.checkFields(dataEntity, payablebillApplys);
            DynamicObject draftbilltype = (DynamicObject)payableApplyBillDO.get("draftbilltype");
            BigDecimal maxamount = draftbilltype.getBigDecimal("maxamount");
            for (int i = 0; i < payablebillApplys.size(); ++i) {
                DynamicObject payablebillApply = (DynamicObject)payablebillApplys.get(i);
                BigDecimal amount = payablebillApply.getBigDecimal("amount");
                if (null == amount || BigDecimal.ZERO.compareTo(amount) == 0) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getZeroAmount(i + 1));
                    continue;
                }
                if (amount.compareTo(maxamount) <= 0) continue;
                this.addErrorMessage(dataEntity, cdmBizResource.getBatchAmount());
            }
            BigDecimal creditamount = payableApplyBillDO.getBigDecimal("creditamount");
            BigDecimal allAmountofcredit = payableApplyBillDO.getDynamicObjectCollection(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (allAmountofcredit.compareTo(creditamount) == 0) continue;
            String error = ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4e0e\u660e\u7ec6\u5206\u5f55\u975e\u5e9f\u5f03\u7684\u884c\u6388\u4fe1\u5360\u7528\u91d1\u989d\u7d2f\u52a0\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_24", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        logger.info("validate is end");
    }

    private void checkHeadFieldsMustInput(ExtendedDataEntity dataEntity) {
        String error;
        DynamicObject payableApplyBillDO = dataEntity.getDataEntity();
        DynamicObject company = payableApplyBillDO.getDynamicObject("company");
        Date bizdate = payableApplyBillDO.getDate("bizdate");
        DynamicObject draftBillType = payableApplyBillDO.getDynamicObject("draftbilltype");
        DynamicObject currency = payableApplyBillDO.getDynamicObject("currency");
        String billingType = payableApplyBillDO.getString("billingtype");
        DynamicObject creditlimit = payableApplyBillDO.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7533\u8bf7\u7ec4\u7ec7\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_17", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        if (EmptyUtil.isEmpty((Object)bizdate)) {
            error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7533\u8bf7\u65e5\u671f\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_18", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e01\u79cd\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_19", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        if (EmptyUtil.isEmpty((String)billingType)) {
            error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5f00\u7968\u65b9\u5f0f\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_20", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        if (EmptyUtil.isEmpty((DynamicObject)draftBillType)) {
            error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7968\u636e\u7c7b\u578b\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_21", (String)"tmc-cdm-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
        this.checkMustInputFields(dataEntity, draftBillType);
    }

    private void checkMustInputFields(ExtendedDataEntity dataEntity, DynamicObject draftBillType) {
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            DynamicObject accepterCompany;
            DynamicObject payableApplyBillDO = dataEntity.getDataEntity();
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) && EmptyUtil.isEmpty((DynamicObject)(accepterCompany = payableApplyBillDO.getDynamicObject("acceptercompany")))) {
                String error = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u627f\u5151\u4eba\u5168\u79f0\u201d\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_22", (String)"tmc-cdm-business", (Object[])new Object[0]);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
        }
    }

    private void checkFields(ExtendedDataEntity dataEntity, DynamicObjectCollection payablebillApplys) {
        int i = 0;
        for (DynamicObject entry : payablebillApplys) {
            Date draftBillExpireDate;
            Date isSueDate;
            ++i;
            BigDecimal amount = entry.getBigDecimal("amount");
            if (amount == null) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            if ((isSueDate = entry.getDate("issuedate")) == null) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            if ((draftBillExpireDate = entry.getDate("draftbillexpiredate")) == null) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u7968\u636e\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            this.checkEntryMustInputField(dataEntity, entry, i);
        }
    }

    private void checkEntryMustInputField(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        DynamicObject payableApplyBillDO = dataEntity.getDataEntity();
        DynamicObject draftBillType = payableApplyBillDO.getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            String billMedium = draftBillType.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if ("1".equals(billMedium)) {
                    DynamicObject drawerCompany = entry.getDynamicObject("drawercompany");
                    if (EmptyUtil.isEmpty((DynamicObject)drawerCompany)) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                    this.validateMustRecvier(dataEntity, entry, i);
                    DynamicObject receiverBank = entry.getDynamicObject("receiverbank");
                    if (EmptyUtil.isEmpty((DynamicObject)receiverBank)) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u6536\u6b3e\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                } else {
                    DynamicObject receiverBank;
                    String drawerBankName;
                    DynamicObject drawerAccount;
                    DynamicObject drawerCompany = entry.getDynamicObject("drawercompany");
                    if (EmptyUtil.isEmpty((DynamicObject)drawerCompany)) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                    if (EmptyUtil.isEmpty((DynamicObject)(drawerAccount = entry.getDynamicObject("draweraccount")))) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                    if (EmptyUtil.isEmpty((String)(drawerBankName = entry.getString("drawerbankname")))) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                    this.validateMustRecvier(dataEntity, entry, i);
                    String receiverAccount = entry.getString("receiveraccount");
                    if (EmptyUtil.isEmpty((String)receiverAccount)) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u6536\u6b3e\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                    if (EmptyUtil.isEmpty((DynamicObject)(receiverBank = entry.getDynamicObject("receiverbank")))) {
                        String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u6536\u6b3e\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, error, ErrorLevel.Error);
                    }
                }
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                DynamicObject receiverBank;
                String payeeType;
                String drawerBankName;
                DynamicObject drawerAccount;
                DynamicObject drawerCompany = entry.getDynamicObject("drawercompany");
                if (EmptyUtil.isEmpty((DynamicObject)drawerCompany)) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((DynamicObject)(drawerAccount = entry.getDynamicObject("draweraccount")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((String)(drawerBankName = entry.getString("drawerbankname")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((String)(payeeType = entry.getString("payeetype")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                this.validateMustRecvier(dataEntity, entry, i);
                String receiverAccount = entry.getString("receiveraccount");
                if (EmptyUtil.isEmpty((String)receiverAccount)) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u6536\u6b3e\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((DynamicObject)(receiverBank = entry.getDynamicObject("receiverbank")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u6536\u6b3e\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                String payeeType;
                DynamicObject drawerOrg = entry.getDynamicObject("drawerorg");
                if (EmptyUtil.isEmpty((DynamicObject)drawerOrg)) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u51fa\u7968\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_12", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((String)(payeeType = entry.getString("payeetype")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                this.validateMustRecvier(dataEntity, entry, i);
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                String payeeType;
                String drawerBankName;
                DynamicObject drawerAccount;
                DynamicObject drawerCompany = entry.getDynamicObject("drawercompany");
                if (EmptyUtil.isEmpty((DynamicObject)drawerCompany)) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((DynamicObject)(drawerAccount = entry.getDynamicObject("draweraccount")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((String)(drawerBankName = entry.getString("drawerbankname")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((String)(payeeType = entry.getString("payeetype")))) {
                    String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c,\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                    this.addMessage(dataEntity, error, ErrorLevel.Error);
                }
                this.validateMustRecvier(dataEntity, entry, i);
            }
        }
    }

    private void validateMustRecvier(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        String payeetype = entry.getString("payeetype");
        DynamicObject receiver = entry.getDynamicObject("receiver");
        String receiverName = entry.getString("receivername");
        if (!"other".equalsIgnoreCase(payeetype)) {
            if (EmptyUtil.isEmpty((DynamicObject)receiver)) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u6536\u6b3e\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
        } else if (EmptyUtil.isEmpty((String)receiverName)) {
            String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, \u6536\u6b3e\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillApBatchSaveOrSubmitOpValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), i);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
    }
}

