/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillBatchSuretyReleaseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("billstatus");
        sic.add("entry_surety");
        sic.add("sourcebillid");
        sic.add("paybilltype");
        sic.add("billingtype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject payDy = dataEntity.getDataEntity();
            boolean isPayablebill = "cdm_payablebill".equals(payDy.getDataEntityType().getName());
            String paybillTypeStr = "";
            paybillTypeStr = isPayablebill ? payDy.getString("paybilltype") : payDy.getString("billingtype");
            if (EmptyUtil.isEmpty((String)paybillTypeStr) || !paybillTypeStr.contains("guarantee")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u65e0\u4fdd\u8bc1\u91d1\u4fe1\u606f\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6536\u56de\u4fdd\u8bc1\u91d1", (String)"PayableBillBatchSuretyReleaseValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            QFilter idFilter = new QFilter("entry.debtbillid", "=", dataEntity.getBillPkId());
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)"billstatus", (QFilter[])new QFilter[]{idFilter});
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
                DynamicObject payablebillApManual;
                Long sourceBillId;
                boolean suretyBillExists = false;
                if (isPayablebill && EmptyUtil.isNoEmpty((Long)(sourceBillId = Long.valueOf(dataEntity.getDataEntity().getLong("sourcebillid")))) && EmptyUtil.isNoEmpty((DynamicObject)(payablebillApManual = TmcDataServiceHelper.loadSingle((String)"cdm_payablebill_ap_manual", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)sourceBillId)}))) && EmptyUtil.isNoEmpty((DynamicObject)(suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("entry.debtbillid", "=", payablebillApManual.getPkValue())})))) {
                    suretyBillExists = true;
                }
                if (!suretyBillExists) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u65e0\u4fdd\u8bc1\u91d1\u4fe1\u606f\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6536\u56de\u4fdd\u8bc1\u91d1", (String)"PayableBillBatchSuretyReleaseValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            }
            if (BillStatusEnum.AUDIT.getValue().equals(suretyBill.getString("billstatus"))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u56de\u4fdd\u8bc1\u91d1\u5931\u8d25\uff0c\u4ec5\u652f\u6301\u6536\u56de\u5df2\u5ba1\u6838\u7684\u4fdd\u8bc1\u91d1\u5355\u636e", (String)"PayableBillBatchSuretyReleaseValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

