/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillCancelRelatedPreBillValitor
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("relatedelcbillid");
        sic.add("isrelatedprebill");
        sic.add("company");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashSet<Long> companyids = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject paybill = dataEntity.getDataEntity();
            long relatedelcbillid = paybill.getLong("relatedelcbillid");
            boolean isrelatedprebill = paybill.getBoolean("isrelatedprebill");
            DynamicObject company = paybill.getDynamicObject("company");
            if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                companyids.add(company.getLong("id"));
            }
            if (isrelatedprebill && relatedelcbillid != 0L) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5173\u8054\u9884\u51fa\u7968\u7968\u636e\u7684\u6570\u636e\u624d\u80fd\u53d6\u6d88\u5173\u8054\u3002", (String)"PayableBillCancelRelatedPreBillValitor_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (companyids.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

