/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillRelatedPreBillValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("billstatus");
        sic.add("relatedelcbillid");
        sic.add("draftbilltype");
        sic.add("accepterfinorg");
        sic.add("isrelatedprebill");
        sic.add("currency");
        sic.add("company");
        sic.add("draweraccount");
        sic.add("receiver");
        sic.add("draftbilltranstatus");
        sic.add("contractno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashSet<Long> companyids = new HashSet<Long>();
        HashSet<Long> currencyids = new HashSet<Long>();
        HashSet<Long> draweraccountids = new HashSet<Long>();
        HashSet<Long> receiverids = new HashSet<Long>();
        HashSet<String> contractnos = new HashSet<String>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bankCateTypeCodeDy;
            DynamicObject bank_cate;
            DynamicObject receiver;
            DynamicObject draweraccount;
            DynamicObject currency;
            String banktype = null;
            DynamicObject paybill = dataEntity.getDataEntity();
            String status = paybill.getString("billstatus");
            Long relatedelcbillid = paybill.getLong("relatedelcbillid");
            boolean isrelatedprebill = paybill.getBoolean("isrelatedprebill");
            DynamicObject billtype = paybill.getDynamicObject("draftbilltype");
            String settlementType = billtype.getString("settlementtype");
            String billmedium = billtype.getString("billmedium");
            DynamicObject accepterfinorg = paybill.getDynamicObject("accepterfinorg");
            DynamicObject company = paybill.getDynamicObject("company");
            String draftbilltranstatus = paybill.getString("draftbilltranstatus");
            String contractno = paybill.getString("contractno");
            contractnos.add(contractno);
            if (DraftTranStatusEnum.SUCCESS.getValue().equals(draftbilltranstatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u51fa\u7968\u7684\u5e94\u4ed8\u7968\u636e\u4e0d\u80fd\u5173\u8054\u9884\u51fa\u7968\u7968\u636e\u3002", (String)"PayableBillRelatedPreBillValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                companyids.add(company.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currency = paybill.getDynamicObject("currency")))) {
                currencyids.add(currency.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(draweraccount = paybill.getDynamicObject("draweraccount")))) {
                draweraccountids.add(draweraccount.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(receiver = paybill.getDynamicObject("receiver")))) {
                receiverids.add(receiver.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)accepterfinorg) && EmptyUtil.isNoEmpty((DynamicObject)(bank_cate = accepterfinorg.getDynamicObject("bank_cate"))) && EmptyUtil.isNoEmpty((DynamicObject)(bankCateTypeCodeDy = BusinessDataServiceHelper.loadSingle((String)"bd_bankcgsetting", (String)"type_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bank_cate.getLong("id"))})))) {
                banktype = bankCateTypeCodeDy.getString("type_code");
            }
            if (!"C".equals(status) || relatedelcbillid != 0L || isrelatedprebill) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u72b6\u6001\u4e14\u672a\u5173\u8054\u7535\u7968\u7684\u6570\u636e\u3002", (String)"PayableBillRelatedPreBillValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if ("105".equals(banktype) && SettleMentTypeEnum.BANK.getValue().equals(settlementType) && BillMediumEnum.ELECTRIC.getValue().equals(billmedium)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5efa\u884c\u7535\u5b50\u94f6\u884c\u627f\u5151\u6c47\u7968\u80fd\u5173\u8054\u9884\u51fa\u7968\u7968\u636e\u3002", (String)"PayableBillRelatedPreBillValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (companyids.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (currencyids.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (draweraccountids.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u51fa\u7968\u4eba\u94f6\u884c\u8d26\u6237\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (receiverids.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u51fa\u7968\u4eba\u6536\u6b3e\u4eba\u5168\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (contractnos.size() > 1) {
            this.addErrorMessage(dataEntitys[0], ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u4ea4\u6613\u5408\u540c\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayableBillRelatedPreBillValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

