/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillSaveValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(PayableBillSaveValidator.class);
    private Map<Long, String> openParamOrgIdMap = new HashMap<Long, String>(16);
    private Map<String, List<DynamicObject>> chequeIdAndDyMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> accountIdAndCateIdMap = new HashMap<Long, DynamicObject>(16);
    private Map<String, List<DynamicObject>> subbillrangeDyMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> payIdAndDyMap = new HashMap<Long, DynamicObject>(16);
    private Set<String> draftTypeSet = Stream.of(SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("draweraccount");
        selector.add("draftbillno");
        selector.add("subbillrange");
        selector.add("receiver");
        selector.add("supperbillamount");
        selector.add("sourcebillid");
        selector.add("draftbilltype");
        selector.add("amount");
        selector.add("receiveraccount");
        selector.add("billno");
        selector.add("payeetype");
        selector.add("drawerbankno");
        selector.add("issplit");
        selector.add("paybilltype");
        selector.add("creditlimit");
        selector.add("guaranteeinfoentry");
        selector.add("entry_surety");
        selector.add("billpoolinfoentry");
        selector.add("subbillendflag");
        selector.add("subbillstartflag");
        selector.add("subbillquantity");
        selector.add("draweraccount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        CdmBizResource cdmBizResource = new CdmBizResource();
        logger.info("use appid=0=GV6L3QZ3D+ check limits");
        this.preDealDataForDB(dataEntitys);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject payBill;
            DynamicObject basedraftbillno;
            DynamicObject data = dataEntity.getDataEntity();
            long companyId = data.getLong("company.id");
            String ignorejudgereArr = this.openParamOrgIdMap.get(companyId);
            boolean needJudgeRep = EmptyUtil.isEmpty((String)ignorejudgereArr) || !ignorejudgereArr.contains("pay");
            DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
            long bankCate = 0L;
            if (null != drawerAccount) {
                long accountId = drawerAccount.getLong("id");
                DynamicObject accountDy = this.accountIdAndCateIdMap.get(accountId);
                bankCate = null != accountDy ? accountDy.getLong("bank.bank_cate") : 0L;
            }
            long bankCateId = bankCate;
            String draftBillNo = data.getString("draftbillno");
            String subBillRange = data.getString("subbillrange");
            boolean issplit = data.getBoolean("issplit");
            this.validateSubBill(dataEntity, data);
            DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.businessOrBankValidate(dataEntity, data, cdmBizResource);
            }
            DynamicObject currency = data.getDynamicObject("currency");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue()) && !EmptyUtil.isEmpty((DynamicObject)currency) && !EmptyUtil.isEmpty((DynamicObject)(basedraftbillno = data.getDynamicObject("basedraftbillno")))) {
                long chequeCurrency;
                List chequePurchBills;
                String billno = basedraftbillno.getString("billno");
                DynamicObject company = data.getDynamicObject("company");
                long companyPkId = company.getLong("id");
                long draftBillTypePkId = draftBillType.getLong("id");
                long accountbankPkId = null != drawerAccount ? drawerAccount.getLong("id") : 0L;
                List<DynamicObject> chequePurchBillsByDraftno = this.chequeIdAndDyMap.get(billno);
                if (!(EmptyUtil.isEmpty(chequePurchBillsByDraftno) || EmptyUtil.isEmpty(chequePurchBills = chequePurchBillsByDraftno.stream().filter(e -> companyPkId == e.getLong("org") && draftBillTypePkId == e.getLong("billtype") && accountbankPkId == e.getLong("accountbank")).collect(Collectors.toList())) || EmptyUtil.isEmpty((Long)(chequeCurrency = ((DynamicObject)chequePurchBills.get(0)).getLong("currency"))) || StringUtils.equals((CharSequence)currency.getString("name"), (CharSequence)((DynamicObject)chequePurchBills.get(0)).getString("currency.name")))) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getCurrencyNotEqual());
                }
            }
            boolean isSupportSplit = this.draftTypeSet.contains(settlementType);
            if (StringUtils.isNotEmpty((CharSequence)draftBillNo)) {
                if (0L == bankCateId) {
                    if (needJudgeRep && this.isExist(drawerAccount, data)) {
                        this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                    }
                } else {
                    List<DynamicObject> payableBillsFromMap = this.subbillrangeDyMap.get(data.getString("draftbillno"));
                    List<Object> payableBills = new ArrayList(16);
                    if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
                        payableBills = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue()) ? payableBillsFromMap.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype")) && bankCateId == e.getLong("draweraccount.bank.bank_cate")).collect(Collectors.toList()) : payableBillsFromMap.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype")) && bankCateId == e.getLong("draweraccount.bank.bank_cate")).collect(Collectors.toList());
                    }
                    if (needJudgeRep && !isSupportSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
                        this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                    }
                    if (needJudgeRep && isSupportSplit && !issplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
                        this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                    }
                    boolean isExistNoSplit = false;
                    for (DynamicObject dynamicObject : payableBills) {
                        boolean isSplitDb = dynamicObject.getBoolean("issplit");
                        if (isSplitDb) continue;
                        isExistNoSplit = true;
                        break;
                    }
                    if (needJudgeRep && isSupportSplit && issplit && isExistNoSplit) {
                        this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                    }
                    if (needJudgeRep && isSupportSplit && issplit && StringUtils.isNotEmpty((CharSequence)subBillRange) && subBillRange.contains("-")) {
                        Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
                        Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
                        for (DynamicObject payableBill : payableBills) {
                            String subBillRangeDb = payableBill.getString("subbillrange");
                            if (!this.isRepeatDraftBillNo(subBillRangeDb, startFlag, endFlag)) continue;
                            this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                        }
                    }
                }
            }
            if (!EmptyUtil.isEmpty((Long)data.getLong("sourcebillid")) && null != (payBill = this.payIdAndDyMap.get(data.getLong("sourcebillid")))) {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                String billstatus = payBill.getString("billstatus");
                if (BillStatusEnum.SAVE.getValue().equals(billstatus) || BillStatusEnum.SUBMIT.getValue().equals(billstatus)) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getPayStatausCheck());
                    continue;
                }
                if (!BillStatusEnum.PAYED.getValue().equals(billstatus)) {
                    ids.add(payBill.getLong("id"));
                }
                if (ids.size() > 0) {
                    OperateOption create = OperateOption.create();
                    try {
                        TmcOperateServiceHelper.execOperate((String)"pay_validate", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                    }
                    catch (Exception e2) {
                        this.addErrorMessage(dataEntity, e2.getMessage());
                    }
                }
            }
            DynamicObject draftbilltype = (DynamicObject)data.get("draftbilltype");
            BigDecimal maxamount = draftbilltype.getBigDecimal("maxamount");
            BigDecimal amount = data.getBigDecimal("amount");
            if (amount.compareTo(maxamount) <= 0) continue;
            this.addErrorMessage(dataEntity, cdmBizResource.getAmount());
        }
        logger.info("PayableBillSave Validate is end:");
    }

    private void preDealDataForDB(ExtendedDataEntity[] dataEntitys) {
        DynamicObjectCollection payBillColl;
        QFilter billnoFilter;
        QFilter accountbankIdFilter;
        QFilter billtypeIdFilter;
        QFilter orgIdFilter;
        DynamicObjectCollection chequePurchBills;
        HashSet<Long> companyIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdByCheckSet = new HashSet<Long>(16);
        HashSet<Long> billTypeIdByCheckSet = new HashSet<Long>(16);
        HashSet<Long> accIdByCheckSet = new HashSet<Long>(16);
        HashSet<String> billnoByCheckSet = new HashSet<String>(16);
        HashSet<Long> accIdBySet = new HashSet<Long>(16);
        HashSet<Long> dataIdSet = new HashSet<Long>(16);
        HashSet<String> draftbillnoSet = new HashSet<String>(16);
        HashSet<Long> sourceIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject basedraftbillno;
            DynamicObject data = dataEntity.getDataEntity();
            long companyId = data.getLong("company.id");
            companyIdSet.add(companyId);
            dataIdSet.add(data.getLong("id"));
            draftbillnoSet.add(data.getString("draftbillno"));
            DynamicObject currency = data.getDynamicObject("currency");
            DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
            String settlementType = draftBillType.getString("settlementtype");
            DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
            if (null != drawerAccount) {
                accIdBySet.add(drawerAccount.getLong("id"));
            }
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue()) && !EmptyUtil.isEmpty((DynamicObject)currency) && !EmptyUtil.isEmpty((DynamicObject)(basedraftbillno = data.getDynamicObject("basedraftbillno")))) {
                DynamicObject company = data.getDynamicObject("company");
                orgIdByCheckSet.add(company.getLong("id"));
                billTypeIdByCheckSet.add(draftBillType.getLong("id"));
                if (null != drawerAccount) {
                    accIdByCheckSet.add(drawerAccount.getLong("id"));
                }
                billnoByCheckSet.add(basedraftbillno.getString("billno"));
            }
            if (EmptyUtil.isEmpty((Long)data.getLong("sourcebillid"))) continue;
            long sourcebillid = data.getLong("sourcebillid");
            sourceIdSet.add(sourcebillid);
        }
        if (EmptyUtil.isNoEmpty(billnoByCheckSet) && !EmptyUtil.isEmpty((DynamicObjectCollection)(chequePurchBills = QueryServiceHelper.query((String)"cdm_cheque_book", (String)"id,billno,billtype,accountbank,org,currency,currency.name", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("org.id", "in", orgIdByCheckSet), billtypeIdFilter = new QFilter("billtype.id", "in", billTypeIdByCheckSet), accountbankIdFilter = new QFilter("accountbank.id", "in", accIdByCheckSet), billnoFilter = new QFilter("billno", "in", billnoByCheckSet)})))) {
            this.chequeIdAndDyMap = chequePurchBills.stream().collect(Collectors.groupingBy(e -> e.getString("billno")));
        }
        QFilter draftBillNoFilter = new QFilter("draftbillno", "in", draftbillnoSet);
        QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
        QFilter draftStatusFilter = new QFilter("billstatus", "!=", (Object)"H");
        QFilter exceptFilter = new QFilter("id", "not in", dataIdSet);
        QFilter payBillFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
        QFilter allAfilter = draftBillNoFilter.and(draftBillStatusFilter).and(draftStatusFilter).and(exceptFilter).and(payBillFilter);
        DynamicObjectCollection payableBillsColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,issplit,subbillrange,draftbillno,draweraccount,draweraccount.bank.bank_cate,draftbilltype,draftbilltype.settlementtype", (QFilter[])new QFilter[]{allAfilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payableBillsColl)) {
            this.subbillrangeDyMap = payableBillsColl.stream().collect(Collectors.groupingBy(e -> e.getString("draftbillno")));
            Set payBillAccountIDSet = payableBillsColl.stream().map(e -> e.getLong("draweraccount")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(payBillAccountIDSet)) {
                accIdBySet.addAll(payBillAccountIDSet);
            }
        }
        if (EmptyUtil.isNoEmpty(accIdBySet)) {
            DynamicObjectCollection drawerAccountColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank,bank.bank_cate,bank.bebank,bank.bebank.number", (QFilter[])new QFilter[]{new QFilter("id", "in", accIdBySet)});
            this.accountIdAndCateIdMap = drawerAccountColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        if (EmptyUtil.isNoEmpty(companyIdSet)) {
            Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
            for (Map.Entry paraMap : paraMaps.entrySet()) {
                String keyId = (String)paraMap.getKey();
                Map valueMap = (Map)paraMap.getValue();
                String ignorejudgere = (String)valueMap.get("ignorejudgere");
                if (!EmptyUtil.isNoEmpty((String)ignorejudgere)) continue;
                this.openParamOrgIdMap.put(Long.parseLong(keyId), ignorejudgere);
            }
        }
        if (EmptyUtil.isNoEmpty(sourceIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(payBillColl = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIdSet)})))) {
            this.payIdAndDyMap = payBillColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        logger.info("PayableBillSave validator preDealDbData is end:");
    }

    private void validateSubBill(ExtendedDataEntity dataEntity, DynamicObject bill) {
        Boolean isSplit = bill.getBoolean("issplit");
        if (isSplit.booleanValue()) {
            BigDecimal newAmount;
            long subbillstartflag = bill.getLong("subbillstartflag");
            long subbillendflag = bill.getLong("subbillendflag");
            BigDecimal amount = bill.getBigDecimal("supperbillamount");
            BigDecimal subBillAmount = bill.getBigDecimal("amount");
            if (subbillstartflag < 1L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u7684\u503c\u9700\u5927\u4e8e\u7b49\u4e8e1", (String)"SubBillEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else if (subbillendflag < 1L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u7684\u503c\u9700\u5927\u4e8e\u7b49\u4e8e1", (String)"SubBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else if (subbillstartflag > subbillendflag) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6", (String)"SubBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else if (BigDecimal.ZERO.compareTo(amount) < 0 && subBillAmount.compareTo(amount) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6bcd\u7968\u91d1\u989d", (String)"SubBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
            long subbillquantity = bill.getLong("subbillquantity");
            long newSubbillquantity = subbillendflag - subbillstartflag + 1L;
            if (subbillquantity != newSubbillquantity) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5bf9\u5e94\u7684\u5b50\u7968\u5305\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
            if (subBillAmount.compareTo(newAmount = BigDecimal.valueOf(newSubbillquantity).multiply(new BigDecimal("0.01"))) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5b50\u7968\u5305\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
    }

    private boolean isExist(DynamicObject drawerAccount, DynamicObject data) {
        long accountid;
        DynamicObject accountDy;
        String bebankNumber = "";
        if (null != drawerAccount && null != (accountDy = this.accountIdAndCateIdMap.get(accountid = drawerAccount.getLong("id")))) {
            bebankNumber = accountDy.getString("bank.bebank.number");
        }
        String drawerBankno = data.getString("drawerbankno");
        String subBillRange = data.getString("subbillrange");
        String draftBillNo = data.getString("draftbillno");
        boolean issplit = data.getBoolean("issplit");
        DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
        String settlementType = draftBillType.getString("settlementtype");
        boolean isSupportSplit = this.draftTypeSet.contains(settlementType);
        String number = "";
        if (Objects.isNull(bebankNumber)) {
            if (Objects.isNull(drawerBankno)) {
                return true;
            }
            number = drawerBankno;
        } else {
            number = bebankNumber;
        }
        List<DynamicObject> payableBillsFromMap = this.subbillrangeDyMap.get(draftBillNo);
        List<Object> payableBills = new ArrayList(16);
        String substring = number.substring(0, Math.min(3, number.length()));
        if (settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue())) {
            if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
                payableBills = payableBillsFromMap.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
            }
        } else if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
            payableBills = payableBillsFromMap.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
        }
        if (!isSupportSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        if (isSupportSplit && !issplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        boolean isExistNoSplit = false;
        for (DynamicObject dynamicObject : payableBills) {
            boolean isSplitDb = dynamicObject.getBoolean("issplit");
            if (isSplitDb) continue;
            isExistNoSplit = true;
            break;
        }
        if (isSupportSplit && issplit && isExistNoSplit) {
            return true;
        }
        if (isSupportSplit && issplit && StringUtils.isNotEmpty((CharSequence)subBillRange) && subBillRange.contains("-")) {
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long l = Long.valueOf(subBillRange.split("-")[1]);
            for (DynamicObject dynamicObject : payableBills) {
                long drawerAccountFromDB = dynamicObject.getLong("draweraccount");
                String subBillRangeFrombase = dynamicObject.getString("subbillrange");
                DynamicObject accountDy2 = this.accountIdAndCateIdMap.get(drawerAccountFromDB);
                String bebankNumberStr = "";
                if (null != accountDy2) {
                    bebankNumberStr = accountDy2.getString("bank.bebank.number");
                }
                boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, l);
                if (!EmptyUtil.isNoEmpty((String)bebankNumberStr) || !bebankNumberStr.startsWith(substring) || !isSameSubBillRange) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, Long startFlag, Long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }

    private DynamicObject getBankProperty(DynamicObject drawerAccount, String propName) {
        DynamicObject prop = null;
        if (Objects.isNull(drawerAccount)) {
            return null;
        }
        DynamicObject bank = drawerAccount.getDynamicObject("bank");
        if (Objects.nonNull(bank)) {
            bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName());
            prop = bank.getDynamicObject(propName);
        }
        return prop;
    }

    private void businessOrBankValidate(ExtendedDataEntity dataEntity, DynamicObject data, CdmBizResource cdmBizResource) {
        String drawerBankNo = data.getString("drawerbankno");
        String receiverBankNo = data.getString("receiverbankno");
        String accepterBankNo = data.getString("accepterbankno");
        String accepterAccount = data.getString("accepteraccount");
        if (StringUtils.isEmpty((CharSequence)receiverBankNo)) {
            this.addErrorMessage(dataEntity, cdmBizResource.getMustInputReceiverBankNo());
        }
        DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
        String billMedium = draftBillType.getString("billmedium");
        if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium) && StringUtils.isEmpty((CharSequence)accepterAccount)) {
            this.addErrorMessage(dataEntity, cdmBizResource.getMustInputAccepterAccount());
        }
    }
}

