/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class PayableBillSubmitEleValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(16);
        sic.add("draftbilltranstatus");
        sic.add("electag");
        sic.add("isendorsepay");
        sic.add("draweraccount");
        sic.add("draftbilltype");
        sic.add("drawercompany");
        sic.add("draftbillno");
        sic.add("basedraftbillno");
        sic.add("billstatus");
        sic.add("contractno");
        sic.add("accepterfinorg");
        sic.add("company");
        sic.add("issuedate");
        sic.add("acpflg");
        sic.add("acpfer");
        sic.add("baltyp");
        sic.add("baleac");
        sic.add("elemustcontrol");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntitys)) {
            return;
        }
        Map<Long, DynamicObject> eleConSets = this.getIshaveConset(dataEntitys);
        Map<Long, DynamicObject> finorginfos = this.getFinOrginfo(dataEntitys);
        Map<Long, DynamicObject> bankcgSettings = this.getBankcgsetting(dataEntitys);
        Map<Long, DynamicObject> beBanks = this.getBeBanks(dataEntitys);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object[] bankCgSettings;
            boolean eleMustControl;
            String number;
            DynamicObject bankCat;
            Long bankCatId;
            DynamicObject payableBill = dataEntity.getDataEntity();
            DynamicObject drawerCompany = payableBill.getDynamicObject("drawercompany");
            DynamicObject company = payableBill.getDynamicObject("company");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean isElectronicBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)drawerCompany.getLong("id"), (String)"iselectronicbill");
            if (!isElectronicBill) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u542f\u7528\u63d0\u4ea4\u7535\u7968\u53c2\u6570\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PayableBillSubmitEleValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            Date issuedate = payableBill.getDate("issuedate");
            Date currentDate = DateUtils.getCurrentDate();
            if (issuedate != null && issuedate.before(currentDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7535\u7968\u7684\u51fa\u7968\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayableBillSubmitEleValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject draftBillType = payableBill.getDynamicObject("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            boolean elecTag = payableBill.getBoolean("electag");
            if (elecTag) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u7535\u7968\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayableBillSubmitEleValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (!billMedium.equals("2")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\uff0c\u7968\u636e\u7c7b\u578b\u7684\u7968\u636e\u4ecb\u8d28\u5fc5\u987b\u4e3a\u7535\u7968\u3002", (String)"PayableBillSubmitEleValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equals(payableBill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\uff0c\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"PayableBillSubmitEleValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject data = dataEntity.getDataEntity();
            Long drawerAccountId = (Long)data.getDynamicObject("draweraccount").getPkValue();
            String draftTranStatus = (String)data.get("draftbilltranstatus");
            if (!EmptyUtil.isEmpty((String)draftTranStatus) && !DraftTranStatusEnum.FAILING.getValue().equals(draftTranStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u65f6\u7684\u672a\u51fa\u7968\u7684\u7535\u7968\u53ef\u4ee5\u70b9\u51fb\u63d0\u4ea4\u7535\u7968\u3002", (String)"PayableBillSubmitEleValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (!eleConSets.containsKey(drawerAccountId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u7684\u7968\u636e\u5fc5\u987b\u5728\u7535\u7968\u76f4\u8fde\u8bbe\u7f6e\u5185\u7ef4\u62a4\u51fa\u7968\u4eba\u8d26\u53f7\u3002", (String)"PayableBillSubmitEleValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
            if (!ObjectUtils.isEmpty((Object)drawerAccount)) {
                Long bankId = drawerAccount.getDynamicObject("bank").getLong("id");
                DynamicObject bank = finorginfos.get(bankId);
                if (EmptyUtil.isEmpty((DynamicObject)bank) || bank.getDynamicObject("bank_cate") == null) continue;
                bankCatId = bank.getDynamicObject("bank_cate").getLong("id");
                bankCat = BusinessDataServiceHelper.loadSingle((Object)bankCatId, (String)"bd_bankcgsetting");
                number = bankCat.getString("number");
                String contractNo = data.getString("contractno");
                if ("BC-0030".equals(number) && StringUtil.isEmpty((String)contractNo)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u7535\u7968\u4ea4\u6613\u5408\u540c\u53f7\u5fc5\u586b", (String)"PayableBillSubmitEleValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
            }
            DynamicObject accepterFinOrg = data.getDynamicObject("accepterfinorg");
            String settlementType = draftBillType.getString("settlementtype");
            if (!ObjectUtils.isEmpty((Object)accepterFinOrg) && accepterFinOrg.getLong("id") > 0L && SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                if (accepterFinOrg.getDynamicObject("bank_cate") == null) continue;
                bankCatId = accepterFinOrg.getDynamicObject("bank_cate").getLong("id");
                bankCat = bankcgSettings.get(bankCatId);
                number = bankCat.getString("number");
                if (accepterFinOrg.getDynamicObject("bebank") == null) continue;
                Long beBankId = accepterFinOrg.getDynamicObject("bebank").getLong("id");
                DynamicObject beBank = beBanks.get(beBankId);
                String otherCode = beBank.getString("other_code");
                if ("BC-0030".equals(number) && SettleMentTypeEnum.BANK.getValue().equals(settlementType) && StringUtil.isEmpty((String)otherCode)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u884c\u540d\u884c\u53f7\u7684\u5176\u4ed6\u4ee3\u7801\u5904\u7ef4\u62a4\u627f\u5151\u884c\u7684\u673a\u6784\u53f7\u3002\u5982\u9700\u5177\u4f53\u673a\u6784\u53f7\uff0c\u8bf7\u54a8\u8be2\u627f\u5151\u884c\u3002", (String)"PayableBillSubmitEleValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if ("BC-0026".equals(number) && SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5efa\u884c\u7535\u5b50\u94f6\u884c\u6c47\u7968\u4e0d\u80fd\u76f4\u63a5\u63d0\u4ea4\u7535\u7968\uff0c\u9700\u8981\u5148\u81f3\u7f51\u94f6\u9884\u51fa\u7968\u540e\u518d\u901a\u8fc7\u5173\u8054\u9884\u51fa\u7968\u7968\u636e\u64cd\u4f5c\u4e0e\u5e94\u4ed8\u7968\u636e\u5173\u8054!", (String)"PayableBillSubmitEleValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(payableBill.getLong("id")));
            ArrayList<NoteResult> result = new ArrayList<NoteResult>(1);
            result.add(noteResult);
            boolean isCorrectTime = EleBillCommonHelper.isCorrectTimeToEB(result, payableBill.getDynamicObject("company").getLong("id"));
            if (!isCorrectTime) {
                this.addErrorMessage(dataEntity, noteResult.getErrMsg());
            }
            if (!(eleMustControl = payableBill.getBoolean("elemustcontrol"))) continue;
            String typeCode = "";
            if (!EmptyUtil.isNoEmpty((DynamicObject)accepterFinOrg)) continue;
            DynamicObject bankCate = accepterFinOrg.getDynamicObject("bank_cate");
            if (EmptyUtil.isNoEmpty((DynamicObject)bankCate) && EmptyUtil.isNoEmpty((Object[])(bankCgSettings = TmcDataServiceHelper.load((Object[])new Object[]{bankCate.getLong("id")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"))))) {
                typeCode = bankCgSettings[0].getString("type_code");
            }
            if (!StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue()) || !StringUtils.equals((CharSequence)billMedium, (CharSequence)BillMediumEnum.ELECTRIC.getValue()) || !StringUtils.equals((CharSequence)typeCode, (CharSequence)"308")) continue;
            String acpFlg = payableBill.getString("acpflg");
            BigDecimal acpFer = payableBill.getBigDecimal("acpfer");
            String balTyp = payableBill.getString("baltyp");
            String balEac = payableBill.getString("baleac");
            if (EmptyUtil.isEmpty((String)acpFlg)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u7535\u5b50\u94f6\u627f\u65f6\u9700\u8981\u586b\u5199\u627f\u5151\u7c7b\u578b", (String)"PayableBillSubmitEleValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((BigDecimal)acpFer)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u7535\u5b50\u94f6\u627f\u65f6\u9700\u8981\u586b\u5199\u627f\u5151\u624b\u7eed\u8d39\u7387", (String)"PayableBillSubmitEleValidator_12", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)acpFlg, (CharSequence)"0") && EmptyUtil.isEmpty((String)balTyp)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u7535\u5b50\u94f6\u627f\u65f6\u9700\u8981\u586b\u5199\u4fdd\u8bc1\u91d1\u7c7b\u578b", (String)"PayableBillSubmitEleValidator_13", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)acpFlg, (CharSequence)"0") || !EmptyUtil.isEmpty((String)balEac)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u7535\u5b50\u94f6\u627f\u65f6\u9700\u8981\u586b\u5199\u4fdd\u8bc1\u91d1\u8d26\u53f7", (String)"PayableBillSubmitEleValidator_14", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }

    private Map<Long, DynamicObject> getBeBanks(ExtendedDataEntity[] dataEntitys) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> beBankIds = Arrays.stream(dataEntitys).filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("accepterfinorg")) && SettleMentTypeEnum.BANK.getValue().equals(k.getDataEntity().getDynamicObject("draftbilltype").getString("settlementtype")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("accepterfinorg").getDynamicObject("bank_cate")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("accepterfinorg").getDynamicObject("bebank"))).map(o -> o.getDataEntity().getDynamicObject("accepterfinorg").getDynamicObject("bebank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(beBankIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)beBankIds.toArray(new Long[0]));
            Object[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,other_code", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])bebanks)) {
                map = Arrays.stream(bebanks).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getBankcgsetting(ExtendedDataEntity[] dataEntitys) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> bankCatIds = Arrays.stream(dataEntitys).filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("accepterfinorg")) && SettleMentTypeEnum.BANK.getValue().equals(k.getDataEntity().getDynamicObject("draftbilltype").getString("settlementtype")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("accepterfinorg").getDynamicObject("bank_cate"))).map(o -> o.getDataEntity().getDynamicObject("accepterfinorg").getDynamicObject("bank_cate").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(bankCatIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)bankCatIds.toArray(new Long[0]));
            Object[] bankcgsettings = BusinessDataServiceHelper.load((String)"bd_bankcgsetting", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])bankcgsettings)) {
                map = Arrays.stream(bankcgsettings).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getFinOrginfo(ExtendedDataEntity[] dataEntitys) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> bankIds = Arrays.stream(dataEntitys).filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDataEntity().getDynamicObject("draweraccount"))).map(o -> o.getDataEntity().getDynamicObject("draweraccount").getDynamicObject("bank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(bankIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)bankIds.toArray(new Long[0]));
            Object[] finorginfos = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,number,bank_cate,", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])finorginfos)) {
                map = Arrays.stream(finorginfos).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getIshaveConset(ExtendedDataEntity[] dataEntitys) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> drawerAccountIds = Arrays.stream(dataEntitys).map(o -> o.getDataEntity().getDynamicObject("draweraccount").getLong("ID")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(drawerAccountIds)) {
            QFilter qFilter = new QFilter("defaultaccount.id", "in", (Object)drawerAccountIds.toArray(new Long[0]));
            Object[] eleConSets = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])eleConSets)) {
                for (Object eleConSet : eleConSets) {
                    Long defaultaccountid = eleConSet.getDynamicObject("defaultaccount").getLong("id");
                    map.put(defaultaccountid, (DynamicObject)eleConSet);
                }
            }
        }
        return map;
    }
}

