/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillTradeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("currency");
        sic.add("isendorsepay");
        sic.add("draftbilltype");
        sic.add("draftbillstatus");
        sic.add("electag");
        sic.add("draftbilltranstatus");
        sic.add("billstatus");
        sic.add("availableamount");
        sic.add("lockedamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashSet<Long> companySet = new HashSet<Long>();
        HashSet<Long> currencySet = new HashSet<Long>();
        HashSet<String> draftbilltypeSet = new HashSet<String>();
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String lockSourceType;
            DynamicObject payBill;
            boolean isSuccess;
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            BigDecimal lockedAmount = receivableBillDO.getBigDecimal("lockedamount");
            if (BigDecimal.ZERO.compareTo(lockedAmount) != 0) {
                this.addErrorMessage(dataEntity, cdmBizResource.getLockAmountTradeCheck());
            }
            boolean electag = receivableBillDO.getBoolean("electag");
            String draftBillTranStatus = receivableBillDO.getString("draftbilltranstatus");
            if (electag && draftBillTranStatus.equals("handleing")) {
                this.addErrorMessage(dataEntity, cdmBizResource.getBillSettlementValidatorMsg());
            }
            String billStatus = receivableBillDO.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeStausCheck());
            }
            if (!(isSuccess = StringUtils.equals((CharSequence)receivableBillDO.getString("draftbilltranstatus"), (CharSequence)"success"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillTranStatusWrong());
            }
            DynamicObject company = receivableBillDO.getDynamicObject("company");
            DynamicObject currency = receivableBillDO.getDynamicObject("currency");
            String draftbilltype = receivableBillDO.getDynamicObject("draftbilltype").getString("settlementtype");
            if (companySet.isEmpty()) {
                companySet.add(company.getLong("id"));
            } else if (!companySet.contains(company.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCompanyCheck());
            }
            if (currencySet.isEmpty()) {
                currencySet.add(currency.getLong("id"));
            } else if (!currencySet.contains(currency.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCurrencyCheck());
            }
            if (draftbilltypeSet.isEmpty()) {
                draftbilltypeSet.add(draftbilltype);
            } else if (!draftbilltypeSet.contains(draftbilltype)) {
                // empty if block
            }
            Long pkValue = (Long)receivableBillDO.getPkValue();
            QFilter qFilter = new QFilter("draftbill.fbasedataid", "in", (Object)pkValue);
            QFilter qFilter1 = new QFilter("billstatus", "!=", (Object)BillStatusEnum.PAYED.getValue());
            Object[] Objs = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
            if (EmptyUtil.isNoEmpty((Object[])Objs) && Objs.length > 0) {
                this.addErrorMessage(dataEntity, cdmBizResource.getPayableBillTradeCheck());
            }
            if ((payBill = TmcDataServiceHelper.loadSingle((Object)receivableBillDO.getPkValue(), (String)"cdm_payablebill", (String)"id,isendorsepay,locksourcebilltype,draftbillstatus")).getBoolean("isendorsepay") && !"cas_paybill".equals(lockSourceType = payBill.getString("locksourcebilltype"))) {
                String message = String.format(cdmBizResource.getOccupyMessageTipBySourceType(lockSourceType), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
            if (StringUtils.equals((CharSequence)DraftBillStatusEnum.PAYOFFED.getValue(), (CharSequence)payBill.getString("draftbillstatus"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getPBTradeRemitCheck());
            }
            if (StringUtils.equals((CharSequence)DraftBillStatusEnum.REGISTERED.getValue(), (CharSequence)payBill.getString("draftbillstatus"))) continue;
            this.addErrorMessage(dataEntity, cdmBizResource.getPBTradeDraftBillStatusRemitCheck());
        }
    }
}

