/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(PayableBillUnAuditValidator.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("isendorsepay");
        sic.add("electag");
        sic.add("billstatus");
        sic.add("draftbilltranstatus");
        sic.add("drawercompany");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("draftbillno");
        sic.add("draftbilltype");
        sic.add("billno");
        sic.add("supperbillid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (dataEntity.getDataEntity().getBoolean("electag")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7535\u7968\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PayableBillUnAuditValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equals(dataEntity.getDataEntity().getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PayableBillUnAuditValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            String draftBillTranStatus = dataEntity.getDataEntity().getString("draftbilltranstatus");
            if (StringUtils.isNotEmpty((String)draftBillTranStatus) && !"failing".equalsIgnoreCase(draftBillTranStatus)) {
                this.addErrorMessage(dataEntity, cdmBizResource.getTradeBillUnAuditMsgForPay());
            }
            DynamicObject payableBillDO = dataEntity.getDataEntity();
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            DynamicObject drawerCompany = payableBillDO.getDynamicObject("drawercompany");
            boolean isElectronicBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)drawerCompany.getLong("id"), (String)"iselectronicbill");
            String draftBillType = dataEntity.getDataEntity().getDynamicObject("draftbilltype").getString("billmedium");
            if (isElectronicBill && !"1".equals(draftBillType) && !"".equals(dataEntity.getDataEntity().getString("draftbilltranstatus")) && !"failing".equals(dataEntity.getDataEntity().getString("draftbilltranstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e0d\u4e3a\u7a7a\u6216\u8005\u4ea4\u6613\u5931\u8d25\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"PayableBillUnAuditValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (payableBillDO.getBoolean("isendorsepay")) {
                String message = String.format(cdmBizResource.getRbTradeUnauditCheck(), payableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
            long id = payableBillDO.getLong("id");
            String entityName = payableBillDO.getDataEntityType().getName();
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{id});
            HashSet targetEntityIds = (HashSet)targetBills.get("cdm_receivablebill");
            Object[] recBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetEntityIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())});
            if (!EmptyUtil.isEmpty((Object[])recBills)) {
                String message = String.format(cdmBizResource.getExistTargetBill(), payableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
            long supperbillid = payableBillDO.getLong("supperbillid");
            String sourceStr = payableBillDO.getString("source");
            logger.info("supperbillid is:" + supperbillid + ",sourceStr:" + sourceStr);
            if (!EmptyUtil.isNoEmpty((String)sourceStr) || !"cdm".equalsIgnoreCase(sourceStr) || !EmptyUtil.isNoEmpty((Long)supperbillid)) continue;
            this.addErrorMessage(dataEntity, cdmBizResource.getSplitBillCheck());
        }
    }
}

