/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableCanDrawValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(PayableCanDrawValidator.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(32);
        sic.add("draftbilltranstatus");
        sic.add("electag");
        sic.add("isendorsepay");
        sic.add("draweraccount");
        sic.add("billstatus");
        sic.add("draftbillstatus");
        sic.add("draftbilltype");
        sic.add("draftbillstatus");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("draftbillno");
        sic.add("locksourcebilltype");
        sic.add("locksourcebillid");
        sic.add("supperbillid");
        sic.add("billno");
        sic.add("lockedamount");
        sic.add("releatedcasbillentrys");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        CdmBizResource cdmBizResource = new CdmBizResource();
        Map<Object, Object> idAndLockAmountMap = new HashMap(16);
        if (EmptyUtil.isNoEmpty((Object[])this.dataEntities)) {
            Set payBillIdSet = Arrays.stream(this.dataEntities).map(e -> e.getDataEntity().getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection payBilLockAmount = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,lockedamount", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIdSet)});
            idAndLockAmountMap = payBilLockAmount.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("lockedamount")));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isRefund;
            String sourceLockType;
            String source;
            QFilter qfid;
            QFilter qfbookstype;
            DynamicObjectCollection dynBookTypeColl;
            Map botpMapPay;
            HashSet pkValuesPay;
            long payBIllId;
            BigDecimal lockedamount;
            DynamicObject data = dataEntity.getDataEntity();
            String billStatus = data.getString("billstatus");
            if (!"C".equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u53ef\u4ee5\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)(lockedamount = (BigDecimal)idAndLockAmountMap.get(payBIllId = data.getLong("id")))) && BigDecimal.ZERO.compareTo(lockedamount) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u9501\u5b9a\u91d1\u989d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968\u3002", (String)"CdmBizResource_179", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
            String draftTranStatus = data.getString("draftbilltranstatus") == null ? "" : data.getString("draftbilltranstatus");
            boolean eleBoolean = data.getBoolean("electag");
            if (!draftTranStatus.equals(DraftTranStatusEnum.SUCCESS.getValue()) || eleBoolean) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u4e14\u4e0d\u662f\u63d0\u4ea4\u7535\u7968\u7684\u8bb0\u5f55\u624d\u53ef\u4ee5\u53d6\u6d88\u51fa\u7968\u3002", (String)"PayableCanDrawValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (DraftBillStatusEnum.SPLITED.getValue().equals(data.getString("draftbillstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u662f\u5df2\u62c6\u5206\u7684\u7968\u636e\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_payablebill", (Long[])new Long[]{data.getLong("id")});
            HashSet pkValues = (HashSet)botpMap.get("cdm_drafttradebill");
            if (DraftBillStatusEnum.PAYOFFED.getValue().equals(data.getString("draftbillstatus")) && null != pkValues && pkValues.size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u662f\u5df2\u89e3\u4ed8\uff0c\u53ea\u6709\u6ca1\u6709\u5173\u8054\u7684\uff08\u7968\u636e\u89e3\u4ed8\uff09\u4e1a\u52a1\u5904\u7406\u5355\u636e\u7684\u7968\u636e\u53ef\u4ee5\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (null != (pkValuesPay = (HashSet)(botpMapPay = BFTrackerServiceHelper.findTargetBills((String)"cdm_payablebill", (Long[])new Long[]{data.getLong("id")})).get("cdm_receivablebill")) && pkValuesPay.size() > 0 && (dynBookTypeColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{qfbookstype = new QFilter("billstatus", "!=", (Object)Character.valueOf('A')), qfid = new QFilter("id", "in", (Object)pkValuesPay)})).size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u4e0b\u6e38\u7684\u5e94\u6536\u7968\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!(source = data.getString("source")).equals(SourceEnum.CAS.getValue())) {
                Set matchCasPayEntry;
                DynamicObjectCollection casEntrys = data.getDynamicObjectCollection("releatedcasbillentrys");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casEntrys) && EmptyUtil.isNoEmpty(matchCasPayEntry = casEntrys.stream().filter(e -> !e.getBoolean("rel_isrefuse") && "cas_paybill".equals(e.getString("rel_billtype"))).collect(Collectors.toSet()))) {
                    String draftBillno = data.getString("billno");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e %s \u5df2\u88ab\u51fa\u7eb3\u4ed8\u6b3e\u5355\u5173\u8054,\u4e0d\u5141\u8bb8\u53d6\u6d88\u51fa\u7968\u3002", (String)"PayableCanDrawValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                }
            } else {
                DynamicObject paybill;
                String matchflag;
                String sourceIdStr;
                long sourCasBillId;
                DynamicObjectCollection payBills;
                String draftStatus = data.getString("draftbillstatus");
                if (DraftBillStatusEnum.PAYOFFED.getValue().equals(draftStatus) && DraftHelper.isPromissory((Object)data.getDynamicObject("draftbilltype")) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,matchflag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourCasBillId = Long.parseLong(sourceIdStr = data.getString("sourcebillid"))))}))) && !"0".equals(matchflag = (paybill = (DynamicObject)payBills.get(0)).getString("matchflag")) && !"8".equals(matchflag)) {
                    String draftBillno = data.getString("billno");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7968\u636e %s \u5bf9\u5e94\u7684\u4ed8\u6b3e\u5904\u7406\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u6216\u5339\u914d\u5f02\u5e38\uff0c\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968\u3002", (String)"PayableCanDrawValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                }
            }
            long supperbillid = data.getLong("supperbillid");
            String sourceStr = data.getString("source");
            logger.info("supperbillid is:" + supperbillid + ",sourceStr:" + sourceStr);
            if (EmptyUtil.isNoEmpty((String)sourceStr) && "cdm".equalsIgnoreCase(sourceStr) && EmptyUtil.isNoEmpty((Long)supperbillid)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7968\u636e\u5c5e\u4e8e\u62c6\u5206\u540e\u7684\u7968\u636e\uff0c\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(sourceLockType = data.getString("locksourcebilltype")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7968\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u4f7f\u7528\u800c\u9501\u5b9a\uff0c\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!(isRefund = QueryServiceHelper.exists((String)"cdm_drafttradebill", (QFilter[])new QFilter("entrys.draftbill.id", "=", (Object)data.getLong("id")).and("tradetype", "=", (Object)DraftTradeTypeEnum.REFUND.getValue()).and("billstatus", "!=", (Object)"S").toArray()))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5b58\u5728\u975e\u4f5c\u5e9f\u72b6\u6001\u7684\u7968\u636e\u9000\u7968\u7684\u4e1a\u52a1\u5904\u7406\u5355\u636e\uff0c\u4e0d\u80fd\u53d6\u6d88\u51fa\u7968", (String)"PayableCanDrawValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

