/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PledgeApplyBillPushValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("billstatus");
        sic.add("entrys");
        sic.add("isinvalid");
        sic.add("ispushtradebill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObjectCollection entrysColl;
            List noInvalidEntry;
            DynamicObject data = dataEntity.getDataEntity();
            String status = data.getString("billstatus");
            Boolean isPushTradeBill = data.getBoolean("ispushtradebill");
            if (!BillStatusEnum.AUDIT.getValue().equals(status)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u63d0\u4ea4\u4e1a\u52a1\u5904\u7406\u3002", (String)"DiscountApplyBillPushValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (isPushTradeBill.booleanValue()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u4e1a\u52a1\u5904\u7406\u3002", (String)"DiscountApplyBillPushValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (!EmptyUtil.isEmpty(noInvalidEntry = (entrysColl = data.getDynamicObjectCollection("entrys")).stream().filter(e -> !e.getBoolean("isinvalid")).collect(Collectors.toList()))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d28\u62bc\u4e1a\u52a1\u7533\u8bf7\u5355\u7684\u7968\u636e\u5206\u5f55\u5df2\u7ecf\u5168\u90e8\u4f5c\u5e9f\u3002", (String)"DiscountApplyBillPushValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

