/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillSubmitValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(ReceivableBillSubmitValidator.class);
    private Map<String, List<DynamicObject>> draftbillnoAndDyMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, List<DynamicObject>> bebankAndDyMap = new HashMap<Long, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> casRecBillMap = new HashMap<Long, DynamicObject>(16);
    private Map<String, Map<String, Object>> paramMaps = new HashMap<String, Map<String, Object>>(16);
    private Set<String> draftTypeSet = Stream.of(SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(24);
        sic.add("company");
        sic.add("receivername");
        sic.add("delivername");
        sic.add("drawername");
        sic.add("acceptno");
        sic.add("receiveraccount");
        sic.add("draftbilltype");
        sic.add("sourcebillid");
        sic.add("bankaccount");
        sic.add("endorseentry");
        sic.add("draftbillno");
        sic.add("sourcedraft");
        sic.add("drawerbank");
        sic.add("accepterbebank");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("issplit");
        sic.add("amount");
        sic.add("subbillstartflag");
        sic.add("subbillendflag");
        sic.add("subbillrange");
        sic.add("casamount");
        sic.add("currency");
        sic.add("issuepromiserdate");
        sic.add("acceptpromiserdate");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("issueticketexpiredate");
        sic.add("promiseexpiredate");
        sic.add("draftbillexpiredate");
        sic.add("isfromequalspilt");
        sic.add("isequalbill");
        sic.add("subbillquantity");
        sic.add("supperbillid");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("draftbilltype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        logger.info("ReceivableBillSubmitValidator validate is start that");
        CdmBizResource cdmBizResource = new CdmBizResource();
        logger.info("use appid=0=GV6L3QZ3D+ check limits");
        Map draftTypeIdAndValidDataMap = DraftHelper.getDraftBillDefaultExpireDate((ExtendedDataEntity[])dataEntities, null, (boolean)false);
        this.predealData(dataEntities);
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            String settlementType;
            DynamicObject draftbilltypeDO;
            BigDecimal amount;
            boolean split;
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            String companyId = receivableBillDO.getString("company.id");
            String ignoreJudgeReArr = (String)this.paramMaps.get(companyId).get("ignorejudgere");
            boolean needJudgeRep = EmptyUtil.isEmpty((String)ignoreJudgeReArr) || !ignoreJudgeReArr.contains("rec");
            long supperBillId = receivableBillDO.getLong("supperbillid");
            long sourceBillId = receivableBillDO.getLong("sourcebillid");
            if (EmptyUtil.isNoEmpty((Long)sourceBillId) && sourceBillId > 0L) {
                DynamicObject casRecBill = this.casRecBillMap.get(sourceBillId);
                logger.info("ReceivableBillSubmitValidator.validate supperBillId:{},sourceBillId:{},casRecBill:{}", new Object[]{supperBillId, sourceBillId, casRecBill == null ? "" : casRecBill.getString("billno")});
                if (EmptyUtil.isEmpty((Long)supperBillId) && casRecBill != null && casRecBill.getLong("id") != receivableBillDO.getLong("sourcebillid")) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getTipRecDrafts());
                }
            }
            DynamicObject draftType = receivableBillDO.getDynamicObject("draftbilltype");
            Date issueDate = receivableBillDO.getDate("issuedate");
            if (null != draftType) {
                Date validDate;
                Map dateDateMap;
                long drafttypeId = draftType.getLong("id");
                Date draftbillExpireDate = receivableBillDO.getDate("draftbillexpiredate");
                if (EmptyUtil.isNoEmpty((Object)issueDate) && issueDate.compareTo(draftbillExpireDate) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5\u4e0d\u80fd\u65e9\u4e8e\u51fa\u7968\u65e5\u671f\u3002", (String)"PayableBillSubmitValidator_2_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((Object)issueDate) && EmptyUtil.isNoEmpty((Object)(dateDateMap = (Map)draftTypeIdAndValidDataMap.get(drafttypeId))) && null != (validDate = (Date)dateDateMap.get(issueDate)) && validDate.compareTo(draftbillExpireDate) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5\u4e0d\u80fd\u665a\u4e8e\u5bf9\u5e94\u7968\u636e\u7c7b\u578b\u7684\u6700\u5927\u6709\u6548\u671f\u3002", (String)"PayableBillSubmitValidator_2_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
            if (split = receivableBillDO.getBoolean("issplit")) {
                BigDecimal newAmount;
                long newSubbillquantity;
                long subbillquantity;
                amount = receivableBillDO.getBigDecimal("supperbillamount");
                BigDecimal subAmount = receivableBillDO.getBigDecimal("amount");
                long subStartFlag = receivableBillDO.getLong("subbillstartflag");
                long subEndFlag = receivableBillDO.getLong("subbillendflag");
                if (0L == subStartFlag || 0L == subEndFlag) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getSubStartFlagWrong());
                }
                if (BigDecimal.ZERO.compareTo(amount) < 0 && amount.compareTo(subAmount) < 0) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getSubAmountWrong());
                }
                if ((subbillquantity = receivableBillDO.getLong("subbillquantity")) != (newSubbillquantity = subEndFlag - subStartFlag + 1L)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5bf9\u5e94\u7684\u5b50\u7968\u5305\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if (subAmount.compareTo(newAmount = BigDecimal.valueOf(newSubbillquantity).multiply(new BigDecimal("0.01"))) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4\u4e0e\u5b50\u7968\u5305\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CdmBizResource_107_6_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            amount = receivableBillDO.getBigDecimal("amount");
            String sourceStr = receivableBillDO.getString("source");
            if ("cas".equalsIgnoreCase(sourceStr)) {
                BigDecimal actRecAmt;
                DynamicObject casRecBill = this.casRecBillMap.get(sourceBillId);
                int amtPrecision = receivableBillDO.getDynamicObject("currency").getInt("amtprecision");
                if (!ObjectUtils.isEmpty((Object)casRecBill) && (actRecAmt = casRecBill.getBigDecimal("actrecamt").setScale(amtPrecision, RoundingMode.DOWN)).compareTo(amount) != 0) {
                    String message = String.format(cdmBizResource.getCasSubAmountWrong(), actRecAmt);
                    this.addErrorMessage(dataEntity, message);
                }
            }
            Date issuePromiseDate = receivableBillDO.getDate("issuepromiserdate");
            Date accPromiseDate = receivableBillDO.getDate("acceptpromiserdate");
            Date draftBillExpireDate = receivableBillDO.getDate("draftbillexpiredate");
            Date issueTicketExpireDate = receivableBillDO.getDate("issueticketexpiredate");
            Date promiseExpireDate = receivableBillDO.getDate("promiseexpiredate");
            if (issuePromiseDate != null && (issueDate.after(issuePromiseDate) || draftBillExpireDate.before(issuePromiseDate))) {
                this.addMessage(dataEntity, cdmBizResource.getIssuePromiseDateCheck(), ErrorLevel.Error);
            }
            if (accPromiseDate != null && (issueDate.after(accPromiseDate) || draftBillExpireDate.before(accPromiseDate))) {
                this.addMessage(dataEntity, cdmBizResource.getAcceptPromiseDateCheck(), ErrorLevel.Error);
            }
            if (issueTicketExpireDate != null && issueDate.after(issueTicketExpireDate)) {
                this.addMessage(dataEntity, cdmBizResource.getIssueGradeExpireDateCheck(), ErrorLevel.Error);
            }
            if (promiseExpireDate != null && issueDate.after(promiseExpireDate)) {
                this.addMessage(dataEntity, cdmBizResource.getPromiseGradeExpireDateCheck(), ErrorLevel.Error);
            }
            if (Objects.equals((draftbilltypeDO = receivableBillDO.getDynamicObject("draftbilltype")).get("billmedium"), BillMediumEnum.ELECTRIC.getValue()) && Objects.isNull(receivableBillDO.get("bankaccount"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getBankAccountCheck());
            }
            boolean isSupportSplit = (settlementType = draftbilltypeDO.getString("settlementtype")).equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
            String subBillRange = receivableBillDO.getString("subbillrange");
            String draftBillNo = receivableBillDO.getString("draftbillno");
            DynamicObject drawerBankObj = receivableBillDO.getDynamicObject("drawerbank");
            List<DynamicObject> recBillByBillnoFromDb = this.draftbillnoAndDyMap.get(draftBillNo);
            HashSet<Long> filterIdSet = new HashSet<Long>(2);
            filterIdSet.add(receivableBillDO.getLong("id"));
            Long sourceDraft = receivableBillDO.getLong("sourcedraft");
            if (EmptyUtil.isNoEmpty((Long)sourceDraft)) {
                filterIdSet.add(receivableBillDO.getLong("sourcedraft"));
            }
            List<Object> bills = new ArrayList(16);
            if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType) || SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                if (EmptyUtil.isNoEmpty(recBillByBillnoFromDb)) {
                    bills = recBillByBillnoFromDb.stream().filter(e -> !filterIdSet.contains(e.getLong("id")) && this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
                }
            } else if (EmptyUtil.isNoEmpty(recBillByBillnoFromDb)) {
                bills = recBillByBillnoFromDb.stream().filter(e -> !filterIdSet.contains(e.getLong("id")) && settlementType.equals(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
            }
            if (!isSupportSplit && bills.size() > 0 && needJudgeRep) {
                logger.info("bills size is:" + bills.size());
                this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillNoCheck());
            }
            if (needJudgeRep && isSupportSplit && !split && bills.size() > 0) {
                logger.info("isSupportSplit bills size is:" + bills.size());
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
            boolean isExistNoSplit = bills.stream().anyMatch(o -> !o.getBoolean("issplit"));
            if (needJudgeRep && isSupportSplit && split && isExistNoSplit) {
                logger.info("isExistNoSplit bills");
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
            if (!needJudgeRep || !isSupportSplit || !split || !StringUtils.isNotEmpty((CharSequence)subBillRange) || !subBillRange.contains("-")) continue;
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
            List<Object> finOrgInfoBills = new ArrayList();
            if (EmptyUtil.isNoEmpty((DynamicObject)drawerBankObj)) {
                finOrgInfoBills = this.bebankAndDyMap.get(drawerBankObj.getLong("id"));
            }
            for (DynamicObject dynamicObject : bills) {
                long drawerBankDo;
                boolean isEqualBill;
                String subBillRangeFrombase = dynamicObject.getString("subbillrange");
                boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, endFlag);
                logger.info("isSameSubBillRange is that:" + isSameSubBillRange);
                if (EmptyUtil.isEmpty((DynamicObject)drawerBankObj)) {
                    if (!isSameSubBillRange) continue;
                    this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillNoCheck());
                    continue block0;
                }
                long billdrawerbank = dynamicObject.getLong("drawerbank");
                if (EmptyUtil.isEmpty((Long)billdrawerbank) && isSameSubBillRange) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillNoCheck());
                    continue block0;
                }
                if (EmptyUtil.isEmpty(finOrgInfoBills)) {
                    String number = drawerBankObj.getString("number");
                    number = number.substring(0, Math.min(number.length(), 3));
                    if (!EmptyUtil.isNoEmpty((Long)billdrawerbank) || null == dynamicObject.getString("drawerbank.number") || !dynamicObject.getString("drawerbank.number").startsWith(number) || !isSameSubBillRange) continue;
                    this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillNoCheck());
                    continue;
                }
                long bankCate = ((DynamicObject)finOrgInfoBills.get(0)).getLong("bank_cate");
                boolean bl = isEqualBill = receivableBillDO.getBoolean("isfromequalspilt") && receivableBillDO.getBoolean("isequalbill");
                if (EmptyUtil.isEmpty((Long)bankCate) || isEqualBill || EmptyUtil.isEmpty((Long)(drawerBankDo = dynamicObject.getLong("drawerbank")))) continue;
                List<DynamicObject> finOrgInfoBillDos = this.bebankAndDyMap.get(drawerBankDo);
                long bankCateDo = 0L;
                if (finOrgInfoBillDos != null && finOrgInfoBillDos.size() > 0) {
                    bankCateDo = finOrgInfoBillDos.get(0).getLong("bank_cate");
                }
                if (EmptyUtil.isEmpty((Long)bankCateDo) || bankCate != bankCateDo || !isSameSubBillRange) continue;
                logger.info("idDo is:" + bankCate);
                this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillNoCheck());
            }
        }
        logger.info("ReceivableBillSubmitValidator validate is end");
    }

    private void predealData(ExtendedDataEntity[] dataEntities) {
        DynamicObjectCollection bdFinorgColl;
        HashSet<Long> drawerbankIdSet = new HashSet<Long>(16);
        HashSet<String> draftbillnoSet = new HashSet<String>(16);
        HashSet<Long> casRecBillIds = new HashSet<Long>(16);
        HashSet<Long> companyIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEn : dataEntities) {
            long companyId;
            String sourceStr;
            String draftBillNo;
            DynamicObject receivableBill = dataEn.getDataEntity();
            DynamicObject drawerbank = receivableBill.getDynamicObject("drawerbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)drawerbank)) {
                drawerbankIdSet.add(drawerbank.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((String)(draftBillNo = receivableBill.getString("draftbillno")))) {
                draftbillnoSet.add(draftBillNo);
            }
            if ("cas".equals(sourceStr = receivableBill.getString("source"))) {
                long sourceId = receivableBill.getLong("sourcebillid");
                casRecBillIds.add(sourceId);
            }
            if (!EmptyUtil.isNoEmpty((Long)(companyId = receivableBill.getDynamicObject("company").getLong("id")))) continue;
            companyIds.add(companyId);
        }
        if (EmptyUtil.isNoEmpty(draftbillnoSet)) {
            QFilter filters = new QFilter("draftbillno", "in", draftbillnoSet);
            filters.and(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
            filters.and(new QFilter("billstatus", "!=", (Object)"H"));
            filters.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
            DynamicObjectCollection recBillFromDb = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,draftbillno,issplit,drawerbank,drawerbank.number,subbillrange,draftbilltype.settlementtype", (QFilter[])new QFilter[]{filters});
            Set otherBebankIdSet = recBillFromDb.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("drawerbank"))).map(e -> e.getLong("drawerbank")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(otherBebankIdSet)) {
                drawerbankIdSet.addAll(otherBebankIdSet);
            }
            this.draftbillnoAndDyMap = recBillFromDb.stream().collect(Collectors.groupingBy(e -> e.getString("draftbillno")));
        }
        if (EmptyUtil.isNoEmpty(drawerbankIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(bdFinorgColl = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bank_cate,bebank", (QFilter[])new QFilter[]{new QFilter("bebank", "in", drawerbankIdSet)})))) {
            this.bebankAndDyMap = bdFinorgColl.stream().collect(Collectors.groupingBy(e -> e.getLong("bebank")));
        }
        if (EmptyUtil.isNoEmpty(casRecBillIds)) {
            QFilter casRecBillFilter = new QFilter("id", "in", casRecBillIds);
            DynamicObjectCollection casRecBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billno,actrecamt,sourcebillid", (QFilter[])new QFilter[]{casRecBillFilter});
            this.casRecBillMap = casRecBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (a, b) -> a));
        }
        if (EmptyUtil.isNoEmpty(companyIds)) {
            this.paramMaps = SystemParameterHelper.getSysParamMap(companyIds);
        }
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, Long startFlag, Long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }
}

