/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.receivablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillTradeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(16);
        sic.add("company");
        sic.add("currency");
        sic.add("isendorsepay");
        sic.add("draftbillstatus");
        sic.add("draftbilltype");
        sic.add("delivername");
        sic.add("draftbilltype");
        sic.add("acceptername");
        sic.add("locksourcebilltype");
        sic.add("locksourcebillid");
        sic.add("isrefund");
        sic.add("issplit");
        sic.add("subbillquantity");
        sic.add("draftbilltranstatus");
        sic.add("ispayinterest");
        sic.add("billstatus");
        sic.add("draftbillno");
        sic.add("availableamount");
        sic.add("amount");
        sic.add("istransfer");
        sic.add("claimnoticebillno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        DynamicObjectCollection recBillFromDbColl;
        DynamicObjectCollection claimColl;
        DynamicObject receivableBillDO;
        HashSet<Long> companySet = new HashSet<Long>();
        HashSet<Long> currencySet = new HashSet<Long>();
        HashSet<String> draftbillstatusSet = new HashSet<String>();
        HashSet<String> delivernameSet = new HashSet<String>();
        HashSet<String> draftbilltypeSet = new HashSet<String>();
        String operateKey = this.getOperateKey();
        CdmBizResource cdmBizResource = new CdmBizResource();
        Set<Object> claimConfirmBillnoSet = new HashSet(16);
        Map<Object, Object> billIdAndDyMap = new HashMap(16);
        HashSet<String> claimNoticBillno = new HashSet<String>(16);
        HashSet<Long> recBillIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            receivableBillDO = dataEntity.getDataEntity();
            String claimNoticBillNo = receivableBillDO.getString("claimnoticebillno");
            if (EmptyUtil.isNoEmpty((String)claimNoticBillNo)) {
                claimNoticBillno.add(claimNoticBillNo);
            }
            long recBillId = receivableBillDO.getLong("id");
            recBillIdSet.add(recBillId);
        }
        if (EmptyUtil.isNoEmpty(claimNoticBillno) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(claimColl = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id,billno,claimstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", claimNoticBillno)})))) {
            claimConfirmBillnoSet = claimColl.stream().filter(e -> "3".equals(e.getString("claimstatus"))).map(e -> e.getString("billno")).collect(Collectors.toSet());
        }
        if (EmptyUtil.isNoEmpty(recBillIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(recBillFromDbColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,draftbillstatus,ispayinterest", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIdSet)})))) {
            billIdAndDyMap = recBillFromDbColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String message;
            DynamicObject draftbilltypeDO;
            String message2;
            boolean available;
            receivableBillDO = dataEntity.getDataEntity();
            BigDecimal availableamount = receivableBillDO.getBigDecimal("availableamount");
            boolean bl = available = availableamount.compareTo(BigDecimal.ZERO) <= 0;
            if (available) {
                String message3 = String.format(cdmBizResource.getAviableAmountCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message3);
                continue;
            }
            boolean istransfer = receivableBillDO.getBoolean("istransfer");
            if (!istransfer && ("discount".equals(operateKey) || "transer".equals(operateKey))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u4e0d\u53ef\u8f6c\u8ba9\u3002", (String)"ReceivableBillTradeValidator_13", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            String billStatus = receivableBillDO.getString("billstatus");
            long id = receivableBillDO.getLong("id");
            DynamicObject recBillFromDb = (DynamicObject)billIdAndDyMap.get(id);
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) continue;
            String claimBillno = receivableBillDO.getString("claimnoticebillno");
            if (EmptyUtil.isNoEmpty((String)claimBillno) && !claimConfirmBillnoSet.contains(claimBillno)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5bf9\u5e94\u7684\u901a\u77e5\u8ba4\u9886\u5355\u4e0d\u662f\u5df2\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"ReceivableBillTradeValidator_13_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"payinterestdeal")) {
                boolean isPayInterest = recBillFromDb.getBoolean("ispayinterest");
                if (isPayInterest) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getPayInterestWrong());
                }
                boolean isEndorsed = StringUtils.equals((CharSequence)DraftBillStatusEnum.ENDORSED.getValue(), (CharSequence)recBillFromDb.getString("draftbillstatus"));
                boolean success = StringUtils.equals((CharSequence)receivableBillDO.getString("draftbilltranstatus"), (CharSequence)"success");
                if (!success || !isEndorsed) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getRecTradeDraftBillStatusRemitCheck());
                }
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"billsplitsub")) {
                long subBillQuantity;
                String locksourceType;
                boolean isSplit;
                String draftbilltranstatus;
                String draftbillstatus = receivableBillDO.getString("draftbillstatus");
                if (!StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillStatusWrong());
                }
                if (!StringUtils.equals((CharSequence)(draftbilltranstatus = receivableBillDO.getString("draftbilltranstatus")), (CharSequence)"success")) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getDraftBillTranStatusWrong());
                }
                if (!(isSplit = receivableBillDO.getBoolean("issplit"))) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getCannotSplitWrong());
                }
                if (!isSplit) continue;
                if (receivableBillDO.getBoolean("isendorsepay") && EmptyUtil.isNoEmpty((String)(locksourceType = receivableBillDO.getString("locksourcebilltype"))) && !"cas_recbill".equals(locksourceType)) {
                    String message4 = String.format(cdmBizResource.getOccupyMessageTipBySourceType(locksourceType), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message4);
                }
                if ((subBillQuantity = receivableBillDO.getLong("subbillquantity")) > 1L) continue;
                this.addErrorMessage(dataEntity, cdmBizResource.getSubBillQuantityWrong());
                continue;
            }
            DynamicObject company = receivableBillDO.getDynamicObject("company");
            DynamicObject currency = receivableBillDO.getDynamicObject("currency");
            String draftbillstatus = recBillFromDb.getString("draftbillstatus");
            String delivername = receivableBillDO.getString("delivername");
            String draftbilltype = receivableBillDO.getDynamicObject("draftbilltype").getString("settlementtype");
            if (companySet.isEmpty()) {
                companySet.add(company.getLong("id"));
            } else if (!companySet.contains(company.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCompanyCheck());
                break;
            }
            if (currencySet.isEmpty()) {
                currencySet.add(currency.getLong("id"));
            } else if (!currencySet.contains(currency.getLong("id"))) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeCurrencyCheck());
                break;
            }
            if (draftbillstatusSet.isEmpty()) {
                draftbillstatusSet.add(draftbillstatus);
            } else if (!draftbillstatusSet.contains(draftbillstatus) && !StringUtils.equals((CharSequence)operateKey, (CharSequence)"collect")) {
                this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeDraftbillStatusCheck());
                break;
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refund")) {
                if (delivernameSet.isEmpty()) {
                    delivernameSet.add(delivername);
                } else if (!delivernameSet.contains(delivername)) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getRbTradeDelivernameCheck());
                    break;
                }
                if (!DraftHelper.isRefund((Object[])new Object[]{id}, (boolean)false)) {
                    this.addErrorMessage(dataEntity, cdmBizResource.getNoReFund());
                    break;
                }
            }
            if (draftbilltypeSet.isEmpty()) {
                draftbilltypeSet.add(draftbilltype);
            }
            if (!StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"discount")) {
                    message2 = String.format(cdmBizResource.getDiscountTradeTranserCheck(), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message2);
                } else if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"collect")) {
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"pledge")) {
                        message2 = String.format(cdmBizResource.getPledgeTradeTranserCheck(), receivableBillDO.getString("billno"));
                        this.addErrorMessage(dataEntity, message2);
                    } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"mandator")) {
                        message2 = String.format(cdmBizResource.getMandatorTradeTranserCheck(), receivableBillDO.getString("billno"));
                        this.addErrorMessage(dataEntity, message2);
                    }
                }
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"rlspledge") && !StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.PLEDGED.getValue())) {
                message2 = String.format(cdmBizResource.getRlspledgeTradeTranserCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message2);
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"retrieve") && !StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.COLLOCATED.getValue())) {
                message2 = String.format(cdmBizResource.getRetrieveTradeTranserCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message2);
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(draftbilltypeDO = receivableBillDO.getDynamicObject("draftbilltype")))) continue;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.COLLOCATED.getValue())) {
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"transer") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"retrieve")) continue;
                    message = String.format(cdmBizResource.getRbTradeCollocatedCheck(), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.PLEDGED.getValue())) {
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"rlspledge") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"collect")) continue;
                    message = String.format(cdmBizResource.getRbTradePledgedCheck(), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                    if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"rlspledge") && !StringUtils.equals((CharSequence)operateKey, (CharSequence)"retrieve")) continue;
                    message = String.format(cdmBizResource.getRbTradeReleaseCheck(), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.ENDORSED.getValue()) && (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refund") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"payinterestdeal"))) {
                    message = String.format(cdmBizResource.getRefundTradeTranserCheck(), receivableBillDO.getString("billno"));
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.ENDORSED.getValue()) && StringUtils.equals((CharSequence)operateKey, (CharSequence)"refund") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"payinterestdeal")) continue;
                message = String.format(cdmBizResource.getRbTradeProcessCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            if (!StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && !StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) continue;
            if (receivableBillDO.getBoolean("isendorsepay")) {
                String locksourceType = receivableBillDO.getString("locksourcebilltype");
                String message5 = String.format(cdmBizResource.getOccupyMessageTipBySourceType(locksourceType), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message5);
                continue;
            }
            if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"transer") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"collect") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"refund") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"pledge")) continue;
                message = String.format(cdmBizResource.getRbTradeProcessCheck(), receivableBillDO.getString("billno"));
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            message = String.format(cdmBizResource.getRbTradeProcessCheck(), receivableBillDO.getString("billno"));
            this.addErrorMessage(dataEntity, message);
        }
    }
}

