/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.GuaranteeTradeTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("credittotalamount");
        selector.add("creditactualamount");
        selector.add("billno");
        selector.add("company");
        selector.add("currency");
        selector.add("creditlimitorg");
        selector.add("creditlimit");
        selector.add("credittype");
        selector.add("drafttype");
        selector.add("name");
        selector.add("bizdate");
        selector.add("billentries");
        selector.add("draftbill");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        this.validateCreditAmount(dataEntities);
        this.validateReleaseGuaranteeBill(dataEntities);
    }

    private void validateReleaseGuaranteeBill(ExtendedDataEntity[] dataEntities) {
        Object[] unGuaranteeBills;
        Object[] guaranteeBills;
        HashSet guaranteeDraftIdSet = new HashSet(8);
        HashSet unGuaranteeDraftIdSet = new HashSet(8);
        Arrays.stream(dataEntities).forEach(data -> {
            Set dataSet = data.getDataEntity().getDynamicObjectCollection("billentries").stream().map(draft -> draft.getDynamicObject("draftbill").getPkValue()).collect(Collectors.toSet());
            if (StringUtils.equals((CharSequence)data.getDataEntity().getString("biztype"), (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue())) {
                guaranteeDraftIdSet.addAll(dataSet);
            } else {
                unGuaranteeDraftIdSet.addAll(dataSet);
            }
        });
        Map billNoAndDraftMap = new HashMap(8);
        HashSet draftIdSet = new HashSet(8);
        draftIdSet.addAll(guaranteeDraftIdSet);
        draftIdSet.addAll(unGuaranteeDraftIdSet);
        QFilter qFilter = new QFilter("id", "in", (Object)draftIdSet.toArray(new Object[0]));
        Object[] draftBills = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,guarantflag,billno", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((Object[])draftBills)) {
            billNoAndDraftMap = Arrays.stream(draftBills).collect(Collectors.toMap(d -> d.getString("billno"), o -> o, (o1, o2) -> o1, HashMap::new));
        }
        HashMap draftNoAndGuaranteeBillNoMap = new HashMap(8);
        HashMap draftNoAndUnGuaranteeBillNoMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty(guaranteeDraftIdSet) && EmptyUtil.isNoEmpty((Object[])(guaranteeBills = TmcDataServiceHelper.load((String)"cdm_guarantee_discount", (String)"id,billno,billentries,billentries.draftbill", (QFilter[])new QFilter[]{new QFilter("billentries.draftbill.id", "in", guaranteeDraftIdSet), new QFilter("biztype", "=", (Object)GuaranteeTradeTypeEnum.GUARANTEE.getValue()), new QFilter("billstatus", "!=", (Object)"C")})))) {
            Arrays.stream(guaranteeBills).forEach(bill -> {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentries");
                entries.forEach(e -> draftNoAndGuaranteeBillNoMap.put(e.getDynamicObject("draftbill").getString("billno"), bill.getString("billno")));
            });
        }
        if (EmptyUtil.isNoEmpty(unGuaranteeDraftIdSet) && EmptyUtil.isNoEmpty((Object[])(unGuaranteeBills = TmcDataServiceHelper.load((String)"cdm_guarantee_discount", (String)"id,billno,billentries,billentries.draftbill", (QFilter[])new QFilter[]{new QFilter("billentries.draftbill.id", "in", unGuaranteeDraftIdSet), new QFilter("biztype", "=", (Object)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue()), new QFilter("billstatus", "!=", (Object)"C")})))) {
            Arrays.stream(unGuaranteeBills).forEach(bill -> {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentries");
                entries.forEach(e -> draftNoAndUnGuaranteeBillNoMap.put(e.getDynamicObject("draftbill").getString("billno"), bill.getString("billno")));
            });
        }
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            String billNo;
            DynamicObjectCollection entries;
            DynamicObject data2 = dataEntity.getDataEntity();
            if (StringUtils.equals((CharSequence)data2.getString("biztype"), (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue())) {
                entries = data2.getDynamicObjectCollection("billentries");
                for (DynamicObject e : entries) {
                    billNo = e.getDynamicObject("draftbill").getString("billno");
                    if (draftNoAndGuaranteeBillNoMap.containsKey(billNo) && !StringUtils.equals((CharSequence)((CharSequence)draftNoAndGuaranteeBillNoMap.get(billNo)), (CharSequence)data2.getString("billno"))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{0}]\u7684\u7968\u636e[{1}]\u5df2\u5173\u8054\u5176\u4ed6\u7684\u672a\u5ba1\u6838\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{2}]\u3002", (String)"GuaranteeSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[]{data2.getString("billno"), billNo, draftNoAndGuaranteeBillNoMap.get(billNo)}), ErrorLevel.Error);
                        continue block0;
                    }
                    if (!billNoAndDraftMap.containsKey(billNo) || !((DynamicObject)billNoAndDraftMap.get(billNo)).getBoolean("guarantflag")) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{0}]\u7684\u7968\u636e[{1}]\u5df2\u5173\u8054\u5176\u4ed6\u7684\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u3002", (String)"GuaranteeSaveValidator_3", (String)"tmc-cdm-business", (Object[])new Object[]{data2.getString("billno"), billNo}), ErrorLevel.Error);
                    continue block0;
                }
                continue;
            }
            entries = data2.getDynamicObjectCollection("billentries");
            for (DynamicObject e : entries) {
                billNo = e.getDynamicObject("draftbill").getString("billno");
                if (draftNoAndUnGuaranteeBillNoMap.containsKey(billNo) && !StringUtils.equals((CharSequence)((CharSequence)draftNoAndUnGuaranteeBillNoMap.get(billNo)), (CharSequence)data2.getString("billno"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{0}]\u7684\u7968\u636e[{1}]\u5df2\u5173\u8054\u5176\u4ed6\u7684\u672a\u5ba1\u6838\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{2}]\u3002", (String)"GuaranteeSaveValidator_2", (String)"tmc-cdm-business", (Object[])new Object[]{data2.getString("billno"), billNo, draftNoAndUnGuaranteeBillNoMap.get(billNo)}), ErrorLevel.Error);
                    continue block0;
                }
                if (!billNoAndDraftMap.containsKey(billNo) || ((DynamicObject)billNoAndDraftMap.get(billNo)).getBoolean("guarantflag")) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e[{0}]\u7684\u7968\u636e[{1}]\u5df2\u5173\u8054\u5176\u4ed6\u7684\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5355\u636e\u3002", (String)"GuaranteeSaveValidator_4", (String)"tmc-cdm-business", (Object[])new Object[]{data2.getString("billno"), billNo}), ErrorLevel.Error);
                continue block0;
            }
        }
    }

    private void validateCreditAmount(ExtendedDataEntity[] dataEntities) {
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            BigDecimal creditActualAmount;
            BigDecimal creditTotalAmount;
            DynamicObject data = dataEntity.getDataEntity();
            if (StringUtils.equals((CharSequence)data.getString("biztype"), (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue()) && (creditTotalAmount = data.getBigDecimal("credittotalamount")).compareTo(creditActualAmount = data.getBigDecimal("creditactualamount")) != 0) {
                this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5355\u636e{0}\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u548c\u5360\u7528\u6388\u4fe1\u989d\u5ea6\u5408\u8ba1\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u5360\u7528\u6388\u4fe1\u3002", (String)"GuaranteeSaveValidator_0", (String)"tmc-cdm-business", (Object[])new Object[]{data.getString("billno")}), ErrorLevel.Error);
            }
        });
    }
}

