/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBilSubmitEleValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(TradeBilSubmitEleValidator.class);
    private List<String> successLockDraftIdList = new ArrayList<String>(8);
    public static final String BILLTYPE = "draw";

    public TradeBilSubmitEleValidator(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("entrys.draftbill");
        selector.add("entrys.changeflag");
        selector.add("billstatus");
        selector.add("electag");
        selector.add("draftbilltranstatus");
        selector.add("company");
        selector.add("tradetype");
        selector.add("recbody");
        selector.add("bankaccount");
        selector.add("isrepay");
        selector.add("isrejectrefund");
        selector.add("isdrawfail");
        selector.add("ispaybyagree");
        selector.add("agreepayertype");
        selector.add("payerofinterest");
        selector.add("payerofinterestname");
        selector.add("payinterbankaccount");
        selector.add("payinteropenbank");
        selector.add("drafttype");
        selector.add("iseditdiscountentry");
        selector.add("discountentry");
        selector.add("changeflag");
        selector.add("rate");
        selector.add("entryisrejectrefund");
        selector.add("entryisrepay");
        selector.add("isrepaygen");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        logger.info("TradeBilSubmitEleValidator is start");
        Set succLockSet = new HashSet(8);
        Set notNeedDealTradeBIllSet = new HashSet(8);
        try {
            Object[] draftIdArr = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("draftbill")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).toArray();
            HashMap<Object, DynamicObject> draftIdToReceivableBillMap = new HashMap<Object, DynamicObject>();
            if (draftIdArr.length > 0) {
                DynamicObject[] receivableBillArr;
                for (DynamicObject receivableBill : receivableBillArr = TmcDataServiceHelper.load((Object[])draftIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                    draftIdToReceivableBillMap.put(receivableBill.getPkValue(), receivableBill);
                }
            }
            HashSet<Long> draftAllBillIdSet = new HashSet<Long>(8);
            ArrayList<DynamicObject> tradeBillDyList = new ArrayList<DynamicObject>(8);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                tradeBillDyList.add(data);
                String billno = data.getString("billno");
                logger.info("TradeBillDrawBillValidator validate billno is" + billno);
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    DynamicObject draftbill = entry.getDynamicObject("draftbill");
                    long draftBillId = draftbill.getLong("id");
                    String draftBillno = draftbill.getString("billno");
                    if (draftAllBillIdSet.contains(draftBillId)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u540c\u4e00\u6279\u6b21\u7684\u4e1a\u52a1\u5904\u7406\u5355\u786e\u8ba4\u5b8c\u6210\u65f6\u4e0d\u80fd\u5305\u542b\u540c\u4e00\u5f20\u7968\u636e%2$s\u3002", (String)"TradeBillDrawBillValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), billno, draftBillno));
                    }
                    draftAllBillIdSet.add(draftBillId);
                }
            }
            Map resultMap = TradeBillHelper.lockByBillId((DynamicObject[])tradeBillDyList.toArray(new DynamicObject[0]), (String)BILLTYPE);
            succLockSet = (Set)resultMap.get("succLockSet");
            notNeedDealTradeBIllSet = (Set)resultMap.get("notNeedDealTradeBIllSet");
            HashSet<String> needSkpiSet = new HashSet<String>(8);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                boolean isRepayOrRejectRefund;
                DynamicObjectCollection tradeEntryCol;
                String draftTranStatus;
                boolean isAllEleBill;
                DynamicObject data = dataEntity.getDataEntity();
                String draftTradeBillId = data.getString("id");
                if (notNeedDealTradeBIllSet.contains(draftTradeBillId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e\u6b63\u5728\u786e\u8ba4\u5b8c\u6210\u6216\u8005\u63d0\u4ea4\u7535\u7968\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"TradeBillDrawBillValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                String tradeType = data.getString("tradetype");
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                boolean haveChangeBill = false;
                HashSet<Long> draftBillIdSet = new HashSet<Long>(8);
                List hasChangeDraftEntry = entrys.stream().filter(e -> e.getBoolean("changeflag")).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(hasChangeDraftEntry)) {
                    haveChangeBill = true;
                }
                for (DynamicObject entry : entrys) {
                    DynamicObject draftbill = entry.getDynamicObject("draftbill");
                    long draftBillId = draftbill.getLong("id");
                    draftBillIdSet.add(draftBillId);
                    DynamicObject draftBillDy = (DynamicObject)draftIdToReceivableBillMap.get(draftBillId);
                    String draftBillTranstatus = draftBillDy.getString("draftbilltranstatus");
                    String draftBillno = draftbill.getString("billno");
                    boolean isHandling = DraftTranStatusEnum.HANDLEING.getValue().equals(draftBillTranstatus);
                    if (!isHandling || haveChangeBill) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e %s \u72b6\u6001\u4e3a\u7535\u7968\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968", (String)"TradeBillDrawBillValidator_0_1_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                    needSkpiSet.add(draftTradeBillId);
                }
                if (EmptyUtil.isNoEmpty(draftBillIdSet)) {
                    boolean isRepayGen = data.getBoolean("isrepaygen");
                    Set<Long> supperTradeIdSet = new HashSet<Long>(16);
                    if (isRepayGen) {
                        Map botpMap;
                        ArrayList<Long> draftTradeIdSet = new ArrayList<Long>(1);
                        long drafttradeId = data.getLong("id");
                        draftTradeIdSet.add(drafttradeId);
                        Map botpMapById = TmcBotpHelper.getSourceBillIdMap((String)"cdm_drafttradebill", draftTradeIdSet, null, null, (boolean)false);
                        if (EmptyUtil.isNoEmpty((Object)botpMapById) && botpMapById.size() > 0 && EmptyUtil.isNoEmpty((Object)(botpMap = (Map)botpMapById.get(drafttradeId))) && botpMap.size() > 0 && EmptyUtil.isNoEmpty(botpMap.get("cdm_drafttradebill"))) {
                            supperTradeIdSet = (Set)botpMap.get("cdm_drafttradebill");
                        }
                    }
                    QFilter qFilterDraft = new QFilter("entrys.draftbill", "in", draftBillIdSet);
                    QFilter qFilterStatus = new QFilter("draftbilltranstatus", "=", (Object)"handleing");
                    long billId = data.getLong("id");
                    supperTradeIdSet.add(billId);
                    QFilter qFilterId = new QFilter("id", "not in", supperTradeIdSet);
                    Object[] drafttrades = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,billno,draftbilltranstatus", (QFilter[])new QFilter[]{qFilterDraft, qFilterStatus, qFilterId});
                    if (EmptyUtil.isNoEmpty((Object[])drafttrades)) {
                        logger.info("is handleing tradebill:" + drafttrades[0].getLong("id"));
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u4e2d\u7684\u7968\u636e\u5df2\u88ab\u5176\u4ed6\u7535\u7968\u5904\u7406\u4e2d\u7684\u4e1a\u52a1\u5904\u7406\u5355 %s \u4f7f\u7528\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968", (String)"TradeBillDrawBillValidator_0_1_5", (String)"tmc-cdm-business", (Object[])new Object[0]), drafttrades[0].getString("billno")));
                        continue;
                    }
                }
                if (EmptyUtil.isNoEmpty(needSkpiSet)) {
                    needSkpiSet.clear();
                    continue;
                }
                if ("refund".equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u9000\u7968\u4e0d\u662f\u7535\u7968\u4e1a\u52a1\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968", (String)"TradeBilSubmitEleValidator_5_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                boolean isdrawfail = data.getBoolean("isdrawfail");
                if (isdrawfail) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_5_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if ("payinterest".equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e70\u65b9\u4ed8\u606f\u4e0d\u5c5e\u4e8e\u7535\u7968\u4e1a\u52a1\uff0c\u65e0\u6cd5\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (DraftTradeTypeEnum.BILLSPLIT.getValue().equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u62c6\u5206\u4e0d\u652f\u6301\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_16", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (DraftTradeTypeEnum.PAYOFF.getValue().equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u89e3\u4ed8\u4e0d\u652f\u6301\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_17", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (DraftTradeTypeEnum.TRUSTEESHIP.getValue().equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u6258\u7ba1\u4e0d\u652f\u6301\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_18", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (DraftTradeTypeEnum.RETRIEVE.getValue().equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6258\u7ba1\u53d6\u56de\u4e0d\u652f\u6301\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_19", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (DraftTradeTypeEnum.RLSPLEDGE.getValue().equalsIgnoreCase(tradeType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d28\u62bc\u89e3\u9664\u4e0d\u652f\u6301\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_20", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject company = data.getDynamicObject("company");
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                boolean isElectronicBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)company.getLong("id"), (String)"iselectronicbill");
                if (!isElectronicBill) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u542f\u7528\u63d0\u4ea4\u7535\u7968\u53c2\u6570\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"TradeBilSubmitEleValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                String billStatus = data.getString("billstatus");
                boolean elecTag = data.getBoolean("electag");
                if (elecTag) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u7535\u7968\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"TradeBilSubmitEleValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                if (!"C".equals(billStatus)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u5141\u8bb8\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
                Object[] sourceBillIdArr = entryList.stream().map(o -> o.getDynamicObject("draftbill")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(draftIdToReceivableBillMap::get).filter(Objects::nonNull).map(o -> o.getLong("sourcebillid")).filter(o -> o != 0L).toArray();
                boolean bl = isAllEleBill = sourceBillIdArr.length == entryList.size();
                if (isAllEleBill) {
                    int eleBillCnt = TmcDataServiceHelper.count((String)"cdm_electronicbill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceBillIdArr)});
                    boolean bl2 = isAllEleBill = eleBillCnt == entryList.size();
                }
                if (!isAllEleBill) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u975e\u7535\u7968\u7b7e\u6536\u7684\u5e94\u6536\u7968\u636e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                String string = draftTranStatus = data.get("draftbilltranstatus") == null ? "" : data.getString("draftbilltranstatus");
                if (haveChangeBill) {
                    if (!(StringUtils.isEmpty((String)draftTranStatus) || draftTranStatus.equals(DraftTranStatusEnum.FAILING.getValue()) || draftTranStatus.equals(DraftTranStatusEnum.PORSUCCESS.getValue()) || draftTranStatus.equals(DraftTranStatusEnum.HANDLEING.getValue()))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u6216\u90e8\u5206\u6210\u529f\u6216\u7535\u7968\u5904\u7406\u4e2d\u624d\u53ef\u4ee5\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_21", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                } else if (!StringUtils.isEmpty((String)draftTranStatus) && !draftTranStatus.equals(DraftTranStatusEnum.FAILING.getValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u624d\u53ef\u4ee5\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if ((tradeEntryCol = data.getDynamicObjectCollection("entrys")).size() == 1 && null == ((DynamicObject)tradeEntryCol.get(0)).getDynamicObject("draftbill")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7968\u636e\u3002", (String)"TradeBilSubmitEleValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                for (DynamicObject tradeEntry : tradeEntryCol) {
                    DynamicObject bankAcct;
                    Long drawerAccountId;
                    QFilter qFilter;
                    Object[] eleConSet;
                    DynamicObject draftBill = (DynamicObject)tradeEntry.get("draftbill");
                    DynamicObject draftBillType = (DynamicObject)draftBill.get("draftbilltype");
                    DynamicObject draftBillTypeDb = BusinessDataServiceHelper.loadSingle((Object)draftBillType.getPkValue(), (String)"cdm_billtype");
                    String billMedium = (String)draftBillTypeDb.get("billmedium");
                    if (!Objects.equals(billMedium, BillMediumEnum.ELECTRIC.getValue())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u7684\u7968\u636e\u4e2d\u5b58\u5728\u7eb8\u7968\uff0c\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if (!ArrayUtils.isEmpty((Object[])(eleConSet = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("defaultaccount.id", "=", (Object)(drawerAccountId = (bankAcct = draftBill.getDynamicObject("bankaccount")) == null ? Long.valueOf(0L) : Optional.ofNullable(bankAcct.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> null)))})))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u7535\u7968\u76f4\u8fde\u8bbe\u7f6e\u5185\u7ef4\u62a4\u9ed8\u8ba4\u7968\u636e\u8d26\u53f7\u3002", (String)"TradeBilSubmitEleValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if ("discount".equals(tradeType)) {
                    boolean isPaybyAgree;
                    DynamicObject bankAccount;
                    DynamicObject reBody;
                    BigDecimal discountRate = data.getBigDecimal("rate");
                    if (discountRate.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d34\u73b0\u4e1a\u52a1\u63d0\u4ea4\u7535\u7968,\u8d34\u73b0\u5229\u7387\u5fc5\u987b\u5927\u4e8e0", (String)"TradeBilSubmitEleValidator_22", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if (!ObjectUtils.isEmpty((Object)(reBody = data.getDynamicObject("recbody")))) {
                        DynamicObject bank_cate = reBody.getDynamicObject("bank_cate");
                        DynamicObject bebankDyn = reBody.getDynamicObject("bebank");
                        if (EmptyUtil.isEmpty((DynamicObject)bebankDyn)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d7\u7406\u673a\u6784\u7684\u94f6\u884c\u7c7b\u522b\u6216\u884c\u540d\u884c\u53f7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u3002", (String)"TradeBilSubmitEleValidator_12", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        } else if (EmptyUtil.isNoEmpty((DynamicObject)bank_cate)) {
                            String number = bank_cate.getString("number");
                            Long beBankId = bebankDyn.getLong("id");
                            DynamicObject beBank = BusinessDataServiceHelper.loadSingle((Object)beBankId, (String)"bd_bebank");
                            String otherCode = beBank.getString("other_code");
                            if ("BC-0030".equals(number) && StringUtil.isEmpty((String)otherCode)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u8d34\u73b0\u9700\u8981\u5728\u884c\u540d\u884c\u53f7\u5176\u4ed6\u4ee3\u7801\u5904\u7ef4\u62a4\u94f6\u884c\u8d26\u53f7\u5f00\u6237\u884c\u53ca\u53d7\u7406\u673a\u6784\u7684\u673a\u6784\u53f7\uff0c\u5177\u4f53\u673a\u6784\u53f7\u8bf7\u54a8\u8be2\u8d34\u73b0\u673a\u6784", (String)"TradeBilSubmitEleValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]));
                            }
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(bankAccount = data.getDynamicObject("bankaccount")))) {
                        Long bankId = bankAccount.getDynamicObject("bank").getLong("id");
                        DynamicObject bank = BusinessDataServiceHelper.loadSingle((Object)bankId, (String)"bd_finorginfo");
                        DynamicObject bebankDynAcc = bank.getDynamicObject("bebank");
                        if (EmptyUtil.isEmpty((DynamicObject)bebankDynAcc)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7684\u5f00\u6237\u884c\u7684\u884c\u540d\u884c\u53f7\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u3002", (String)"TradeBilSubmitEleValidator_13", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        } else {
                            Long beBankId = bebankDynAcc.getLong("id");
                            DynamicObject beBank = BusinessDataServiceHelper.loadSingle((Object)beBankId, (String)"bd_bebank");
                            String otherCode = beBank.getString("other_code");
                            DynamicObject bank_cate = bank.getDynamicObject("bank_cate");
                            if (EmptyUtil.isNoEmpty((DynamicObject)bank_cate)) {
                                DynamicObject bankCat = BusinessDataServiceHelper.loadSingle((Object)bank_cate.getLong("id"), (String)"bd_bankcgsetting");
                                String number = bankCat.getString("number");
                                if ("BC-0030".equals(number) && StringUtil.isEmpty((String)otherCode)) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u8d34\u73b0\u9700\u8981\u5728\u884c\u540d\u884c\u53f7\u5176\u4ed6\u4ee3\u7801\u5904\u7ef4\u62a4\u94f6\u884c\u8d26\u53f7\u5f00\u6237\u884c\u53ca\u53d7\u7406\u673a\u6784\u7684\u673a\u6784\u53f7\uff0c\u5177\u4f53\u673a\u6784\u53f7\u8bf7\u54a8\u8be2\u8d34\u73b0\u673a\u6784", (String)"TradeBilSubmitEleValidator_11", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                }
                            } else {
                                logger.info("bank_cate is null");
                            }
                        }
                    }
                    if (isPaybyAgree = data.getBoolean("ispaybyagree")) {
                        String agreePayerType = data.getString("agreepayertype");
                        if (EmptyUtil.isNoEmpty((String)agreePayerType)) {
                            if ("other".equals(agreePayerType)) {
                                String payerOfinterestName = data.getString("payerofinterestname");
                                if (EmptyUtil.isEmpty((String)payerOfinterestName)) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u534f\u8bae\u4ed8\u606f\u5f00\u542f\u65f6\uff0c\u8bf7\u5b8c\u5584\u534f\u8bae\u4ed8\u606f\u4eba\u7c7b\u578b\u3001\u4ed8\u606f\u4eba\u3001\u4ed8\u606f\u4eba\u94f6\u884c\u8d26\u53f7\u3001\u4ed8\u606f\u4eba\u8d26\u53f7\u5f00\u6237\u884c\u7b49\u4fe1\u606f\u3002", (String)"TradeBilSubmitEleValidator_12_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                }
                            } else {
                                DynamicObject payerOfInterest = data.getDynamicObject("payerofinterest");
                                DynamicObject payinterOpenbank = data.getDynamicObject("payinteropenbank");
                                String payinterBankAccount = data.getString("payinterbankaccount");
                                if (EmptyUtil.isEmpty((DynamicObject)payerOfInterest) || EmptyUtil.isEmpty((DynamicObject)payinterOpenbank) || EmptyUtil.isEmpty((String)payinterBankAccount)) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u534f\u8bae\u4ed8\u606f\u5f00\u542f\u65f6\uff0c\u8bf7\u5b8c\u5584\u534f\u8bae\u4ed8\u606f\u4eba\u7c7b\u578b\u3001\u4ed8\u606f\u4eba\u3001\u4ed8\u606f\u4eba\u94f6\u884c\u8d26\u53f7\u3001\u4ed8\u606f\u4eba\u8d26\u53f7\u5f00\u6237\u884c\u7b49\u4fe1\u606f\u3002", (String)"TradeBilSubmitEleValidator_12_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                                }
                            }
                        } else {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u534f\u8bae\u4ed8\u606f\u5f00\u542f\u65f6\uff0c\u8bf7\u5b8c\u5584\u534f\u8bae\u4ed8\u606f\u4eba\u7c7b\u578b\u3001\u4ed8\u606f\u4eba\u3001\u4ed8\u606f\u4eba\u94f6\u884c\u8d26\u53f7\u3001\u4ed8\u606f\u4eba\u8d26\u53f7\u5f00\u6237\u884c\u7b49\u4fe1\u606f\u3002", (String)"TradeBilSubmitEleValidator_12_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                    }
                }
                if (!(isRepayOrRejectRefund = entryList.stream().allMatch(e -> e.getBoolean("entryisrepay") || e.getBoolean("entryisrejectrefund")))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u91cd\u4ed8\u6216\u62d2\u6536\u9000\u7968\u7684\u7968\u636e\u4e0d\u80fd\u63d0\u4ea4\u7535\u7968\u3002", (String)"TradeBilSubmitEleValidator_14", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            logger.info("\u63d0\u4ea4\u7535\u7968\u6821\u9a8c\u6267\u884c\u5b8c\u6210\u3002");
        }
        catch (Exception e2) {
            logger.error("TradeBilSubmitEleValidator has error", (Throwable)e2);
            throw e2;
        }
        finally {
            if (EmptyUtil.isNoEmpty(succLockSet)) {
                logger.info("will add succLockSet");
                this.successLockDraftIdList.addAll(succLockSet);
            }
        }
    }
}

