/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillChangeSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("havechangeamount");
        sic.add("bechangeamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Object[] tradeNos = Arrays.stream(dataEntities).map(changeBill -> changeBill.getDataEntity().getString("tradebillno")).toArray();
        DynamicObject[] draftTradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)tradeNos)});
        Object[] tradeIds = Arrays.stream(draftTradeBills).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] draftTradeBillList = TmcDataServiceHelper.load((Object[])tradeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        Map<String, DynamicObject> tradeNoToTradeBillMap = Arrays.stream(draftTradeBillList).collect(Collectors.toMap(tradeBill -> tradeBill.getString("billno"), Function.identity()));
        this.validateRepayOrRejectRefund(dataEntities, tradeNoToTradeBillMap);
        this.validateChangeTotalAmount(dataEntities);
    }

    private void validateRepayOrRejectRefund(ExtendedDataEntity[] dataEntities, Map<String, DynamicObject> tradeNoToTradeBillMap) {
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection beChangeEntries = data.getDynamicObjectCollection("bechange_entry");
            Set beChangeBillIds = beChangeEntries.stream().map(beChangeEntry -> beChangeEntry.getDynamicObject("b_draftbill").getLong("id")).collect(Collectors.toSet());
            DynamicObject tradeBill = (DynamicObject)tradeNoToTradeBillMap.get(data.getString("tradebillno"));
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBill)) {
                DynamicObjectCollection entries = tradeBill.getDynamicObjectCollection("entrys");
                for (DynamicObject e : entries) {
                    if (!beChangeBillIds.contains(e.getDynamicObject("draftbill").getLong("id")) || !e.getBoolean("entryisrepay") && !e.getBoolean("entryisrejectrefund")) continue;
                    this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5931\u8d25\u91cd\u4ed8\u6216\u62d2\u6536\u9000\u7968\u7684\u7968\u636e\u4e0d\u652f\u6301\u6362\u7968\u64cd\u4f5c\u3002", (String)"TradeBillChangeSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
    }

    private void validateChangeTotalAmount(ExtendedDataEntity[] dataEntities) {
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject data = dataEntity.getDataEntity();
            BigDecimal haveChangeAmount = data.getBigDecimal("havechangeamount");
            BigDecimal beChangeAmount = data.getBigDecimal("bechangeamount");
            haveChangeAmount = EmptyUtil.isEmpty((BigDecimal)haveChangeAmount) ? BigDecimal.ZERO : haveChangeAmount;
            BigDecimal bigDecimal = beChangeAmount = EmptyUtil.isEmpty((BigDecimal)beChangeAmount) ? BigDecimal.ZERO : beChangeAmount;
            if (haveChangeAmount.compareTo(beChangeAmount) != 0) {
                this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5df2\u6362\u7968\u636e\u91d1\u989d\u5fc5\u987b\u4e0e\u88ab\u6362\u7968\u636e\u91d1\u989d\u76f8\u540c\u3002", (String)"TradeBillChangeSaveValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
        });
    }
}

