/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillChangeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("isinchange");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject tradeBill = data.getDataEntity();
            if (!this.haveBillDoingChange(tradeBill)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5904\u7406\u4e2d\u7684\u6362\u7968\u4e1a\u52a1\uff0c\u518d\u64cd\u4f5c\u3002", (String)"TradeBillChangeValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }

    private boolean haveBillDoingChange(DynamicObject tradeBill) {
        Object tradeId = tradeBill.getPkValue();
        if (EmptyUtil.isNoEmpty((Object)tradeId) && tradeBill.getDataEntityState().getFromDatabase()) {
            DynamicObject tradeBillDB = TmcDataServiceHelper.loadSingle((Object)tradeId, (String)"cdm_drafttradebill");
            DynamicObjectCollection entries = tradeBillDB.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean("isinchange")) continue;
                return true;
            }
        }
        return false;
    }
}

