/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class TradeBillDiscountCustomValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("recbody");
        selector.add("drafttype");
        selector.add("discountentry");
        selector.add("invctype");
        selector.add("invcno");
        selector.add("invccode");
        selector.add("invcchkno");
        selector.add("invcdate");
        selector.add("invcamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        block0: for (ExtendedDataEntity data : dataEntity) {
            Object[] bankCgSettings;
            DynamicObject bankCate;
            DynamicObject tradeBill = data.getDataEntity();
            String tradeType = tradeBill.getString("tradetype");
            if (!tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue())) continue;
            DynamicObject recBody = tradeBill.getDynamicObject("recbody");
            DynamicObject draftType = tradeBill.getDynamicObject("drafttype");
            boolean isICBCBankFlag = false;
            if (!(EmptyUtil.isEmpty((DynamicObject)recBody) || EmptyUtil.isEmpty((DynamicObject)(bankCate = recBody.getDynamicObject("bank_cate"))) || EmptyUtil.isEmpty((Object[])(bankCgSettings = BusinessDataServiceHelper.load((String)"bd_bankcgsetting", (String)"type_code", (QFilter[])new QFilter[]{new QFilter("id", "=", bankCate.getPkValue())}))))) {
                String typeCode = bankCgSettings[0].getString("type_code");
                isICBCBankFlag = StringUtils.equals((String)typeCode, (String)"102");
            }
            String billMedium = draftType.getString("billmedium");
            boolean isEleMedium = StringUtils.equals((String)billMedium, (String)"2");
            if (!isICBCBankFlag || !isEleMedium) {
                return;
            }
            DynamicObjectCollection discountEntrys = tradeBill.getDynamicObjectCollection("discountentry");
            for (DynamicObject discountEntry : discountEntrys) {
                boolean isCheckCodeEmpty;
                String invoiceType = discountEntry.getString("invctype");
                String invoiceNumber = discountEntry.getString("invcno");
                String invoiceCode = discountEntry.getString("invccode");
                String checkCode = discountEntry.getString("invcchkno");
                Date invoiceDate = discountEntry.getDate("invcdate");
                BigDecimal invoiceAmount = discountEntry.getBigDecimal("invcamt");
                boolean isInvoiceFieldEmpty = EmptyUtil.isEmpty((String)invoiceType) || EmptyUtil.isEmpty((String)invoiceNumber) || EmptyUtil.isEmpty((String)invoiceCode) || EmptyUtil.isEmpty((Object)invoiceDate) || EmptyUtil.isEmpty((BigDecimal)invoiceAmount);
                boolean isFourOrSeven = StringUtils.equals((String)invoiceType, (String)"004") || StringUtils.equals((String)invoiceType, (String)"007");
                boolean bl = isCheckCodeEmpty = isFourOrSeven && EmptyUtil.isEmpty((String)checkCode);
                if (!isInvoiceFieldEmpty && !isCheckCodeEmpty) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7535\u7968\u5728\u53d7\u7406\u673a\u6784\u8d34\u73b0\u65f6\uff0c\u8981\u6c42\u5b8c\u6574\u586b\u5199\u53d1\u7968\u4fe1\u606f\uff08\u4e13\u7968\u6216\u666e\u7968\u65f6\uff0c\u6821\u9a8c\u7801\u5fc5\u586b\uff09\uff0c\u8bf7\u8865\u5145\u8d34\u73b0\u660e\u7ec6\u5185\u7684\u53d1\u7968\u4fe1\u606f\u3002", (String)"CdmBizResource_178", (String)"tmc-cdm-common", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

