/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillDrawBillValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(TradeBillDrawBillValidator.class);
    public static final String BILLTYPE = "draw";
    private List<String> successLockDraftIdList = new ArrayList<String>(8);

    public TradeBillDrawBillValidator(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftbilltranstatus");
        selector.add("electag");
        selector.add("entrys");
        selector.add("isrejectrefund");
        selector.add("billstatus");
        selector.add("deposit");
        selector.add("depositdeduct");
        selector.add("deposit");
        selector.add("depositamount");
        selector.add("deductamount");
        selector.add("tradetype");
        selector.add("amount");
        selector.add("billno");
        selector.add("isrepay");
        selector.add("drafttype");
        selector.add("isequalsplit");
        selector.add("isdrawfail");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set succLockSet = new HashSet(8);
        Set notNeedDealTradeBIllSet = new HashSet(8);
        Map variables = this.getOption().getVariables();
        String isdrawfail = (String)variables.get("isdrawfail");
        boolean isDrawFail = "y".equals(isdrawfail);
        try {
            DynamicObject[] draftBillArr;
            HashSet<Long> draftAllBillIdSet = new HashSet<Long>(8);
            ArrayList<DynamicObject> tradeBillDyList = new ArrayList<DynamicObject>(8);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                tradeBillDyList.add(data);
                String billno = data.getString("billno");
                logger.info("TradeBillDrawBillValidator validate billno is" + billno);
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    DynamicObject draftbill = entry.getDynamicObject("draftbill");
                    long draftBillId = draftbill.getLong("id");
                    String draftBillno = draftbill.getString("billno");
                    if (draftAllBillIdSet.contains(draftBillId)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u540c\u4e00\u6279\u6b21\u7684\u4e1a\u52a1\u5904\u7406\u5355\u786e\u8ba4\u5b8c\u6210\u65f6\u4e0d\u80fd\u5305\u542b\u540c\u4e00\u5f20\u7968\u636e%2$s\u3002", (String)"TradeBillDrawBillValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), billno, draftBillno));
                    }
                    draftAllBillIdSet.add(draftBillId);
                }
            }
            HashMap<Long, DynamicObject> draftIdToReceivableBillMap = new HashMap<Long, DynamicObject>(8);
            for (DynamicObject draftBill : draftBillArr = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,draftbilltranstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", draftAllBillIdSet)})) {
                draftIdToReceivableBillMap.put(draftBill.getLong("id"), draftBill);
            }
            Map resultMap = TradeBillHelper.lockByBillId((DynamicObject[])tradeBillDyList.toArray(new DynamicObject[0]), (String)BILLTYPE);
            succLockSet = (Set)resultMap.get("succLockSet");
            notNeedDealTradeBIllSet = (Set)resultMap.get("notNeedDealTradeBIllSet");
            HashSet<String> needSkpiSet = new HashSet<String>(8);
            block8: for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                String billno = data.getString("billno");
                String draftTradeBillId = data.getString("id");
                if (notNeedDealTradeBIllSet.contains(draftTradeBillId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e\u6b63\u5728\u786e\u8ba4\u5b8c\u6210\u6216\u8005\u63d0\u4ea4\u7535\u7968\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"TradeBillDrawBillValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject drafttype = data.getDynamicObject("drafttype");
                logger.info("TradeBillDrawBillValidator validate billno is" + billno);
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    DynamicObject draftbill = entry.getDynamicObject("draftbill");
                    long draftBillId = draftbill.getLong("id");
                    String billmedium = drafttype.getString("billmedium");
                    if (!"2".equals(billmedium)) continue;
                    DynamicObject draftBillDy = (DynamicObject)draftIdToReceivableBillMap.get(draftBillId);
                    String draftBillTranstatus = draftBillDy.getString("draftbilltranstatus");
                    String draftBillno = draftbill.getString("billno");
                    boolean isHandling = DraftTranStatusEnum.HANDLEING.getValue().equals(draftBillTranstatus);
                    if (!isHandling) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u7968\u636e%s\u72b6\u6001\u4e3a\u7535\u7968\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u63d0\u4ea4\u786e\u8ba4\u5b8c\u6210\u3002", (String)"TradeBillDrawBillValidator_0_1_4", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBillno));
                    needSkpiSet.add(draftTradeBillId);
                }
                if (EmptyUtil.isNoEmpty(needSkpiSet)) {
                    needSkpiSet.clear();
                    continue;
                }
                String draftBillTranStatus = data.getString("draftbilltranstatus");
                String billStatus = data.getString("billstatus");
                if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    if (isDrawFail) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u53ef\u4ee5\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    } else {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u53ef\u786e\u8ba4\u5b8c\u6210\u3002", (String)"TradeBillDrawBillValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (isDrawFail) {
                    DynamicObject casPayBill;
                    String billstatus;
                    String draftTranstatus = data.getString("draftbilltranstatus");
                    boolean isHasDrawfail = data.getBoolean("isdrawfail");
                    String tradeType = data.getString("tradetype");
                    String source = data.getString("source");
                    long sourceBillId = data.getLong("sourcebillid");
                    if (EmptyUtil.isNoEmpty((Object)draftTranstatus)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u624d\u5141\u8bb8\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_8_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if (isHasDrawfail) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5df2\u7ecf\u786e\u8ba4\u5931\u8d25\uff0c\u4e0d\u80fd\u91cd\u590d\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_8_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if (!("endorse".equals(tradeType) || "pledge".equals(tradeType) || "discount".equals(tradeType))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u80cc\u4e66\uff0c\u8d34\u73b0\uff0c\u8d28\u62bc\u4e1a\u52a1\u652f\u6301\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_8_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if ("cas".equalsIgnoreCase(source) && EmptyUtil.isNoEmpty((Long)sourceBillId) && "D".equals(billstatus = (casPayBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)})).getString("billstatus"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u5355\u5df2\u7ecf\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_8_4_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                    if ("cdm-draftallocate".equalsIgnoreCase(source) && EmptyUtil.isNoEmpty((Long)sourceBillId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5ea6\u751f\u6210\u7684\u80cc\u4e66\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u5931\u8d25\u3002", (String)"TradeBillDrawBillValidator_8_4_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                } else {
                    boolean isHasDrawfail = data.getBoolean("isdrawfail");
                    if (isHasDrawfail) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5df2\u7ecf\u786e\u8ba4\u5931\u8d25\uff0c\u4e0d\u80fd\u786e\u8ba4\u5b8c\u6210\u3002", (String)"TradeBillDrawBillValidator_8_4_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (isDrawFail) continue;
                if ("payoff".equalsIgnoreCase(data.getString("tradetype"))) {
                    BigDecimal amount;
                    boolean depositdeduct = data.getBoolean("depositdeduct");
                    boolean deposit = data.getBoolean("deposit");
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    if (depositdeduct) {
                        BigDecimal deductamount = data.getBigDecimal("deductamount");
                        totalAmount = totalAmount.add(deductamount);
                    }
                    if (deposit) {
                        BigDecimal depositamount = data.getBigDecimal("depositamount");
                        totalAmount = totalAmount.add(depositamount);
                    }
                    if (totalAmount.compareTo(amount = data.getBigDecimal("amount")) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89e3\u4ed8\u4e1a\u52a1\u7684\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5212\u6263\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e0e\u62b5\u6263\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e4b\u548c", (String)"TradeBillDrawBillValidator_0_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
                if (data.getBoolean("electag")) {
                    DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entryList) {
                        String tranStatus = entry.getString("transtatus");
                        if (!EmptyUtil.isEmpty((String)tranStatus) && !DraftTranStatusEnum.PENDING.getValue().equals(tranStatus) && !DraftTranStatusEnum.HANDLEING.getValue().equals(tranStatus)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5904\u7406\u4e2d\u7684\u5206\u5f55, \u4e0d\u5141\u8bb8\u786e\u8ba4\u5b8c\u6210", (String)"TradeBillDrawBillValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        continue block8;
                    }
                    continue;
                }
                if (StringUtils.isEmpty((String)draftBillTranStatus) || DraftTranStatusEnum.FAILING.getValue().equals(draftBillTranStatus)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u624d\u5141\u8bb8\u786e\u8ba4\u5b8c\u6210", (String)"TradeBillDrawBillValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("TradeBillDrawBillValidator has error", (Throwable)e);
            throw e;
        }
        finally {
            if (EmptyUtil.isNoEmpty(succLockSet)) {
                logger.info("will add succLockSet");
                this.successLockDraftIdList.addAll(succLockSet);
            }
        }
    }
}

