/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class TradeBillRePayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("isrepay");
        selector.add("draftbilltranstatus");
        selector.add("billstatus");
        selector.add("isdrawfail");
        selector.add("isrejectrefund");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObjectCollection entries;
            boolean validateEntryTranStatus;
            DynamicObject tradeBill = data.getDataEntity();
            String tranStatus = tradeBill.getString("draftbilltranstatus");
            boolean isdrawfail = tradeBill.getBoolean("isdrawfail");
            if (isdrawfail) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u53d1\u8d77\u8fc7\u5931\u8d25\u91cd\u4ed8\uff0c\u65e0\u9700\u91cd\u590d\u5931\u8d25\u91cd\u4ed8\u3002", (String)"TradeBillRePayValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!TradeBillHelper.canRepayOrRejectRefundTranStatus((String)tranStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u4ea4\u6613\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u3001\u201c\u7535\u7968\u5904\u7406\u4e2d\u201d\u6216\u201c\u90e8\u5206\u6210\u529f\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRePayValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (validateEntryTranStatus = (entries = tradeBill.getDynamicObjectCollection("entrys")).stream().anyMatch(TradeBillHelper::canRepayOrRejectRefundDraftEntry)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u5e76\u4e14\u6ca1\u6709\u53d1\u751f \u201c\u62d2\u6536\u9000\u7968\u201d\u6216 \u201c\u5931\u8d25\u91cd\u4ed8\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRePayValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

