/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import org.apache.commons.lang3.StringUtils;

public class TradeBillRejectRefundValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftbilltranstatus");
        selector.add("isrepay");
        selector.add("source");
        selector.add("isrejectrefund");
        selector.add("entrys");
        selector.add("transtatus");
        selector.add("isdrawfail");
        selector.add("entrys.transtatus");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            String source;
            DynamicObjectCollection entries;
            boolean validateEntryTranStatus;
            boolean isdrawfail;
            DynamicObject tradeBill = data.getDataEntity();
            String tranStatus = tradeBill.getString("draftbilltranstatus");
            if (!TradeBillHelper.canRepayOrRejectRefundTranStatus((String)tranStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u4ea4\u6613\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u3001\u201c\u7535\u7968\u5904\u7406\u4e2d\u201d\u6216\u201c\u90e8\u5206\u6210\u529f\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRejectRefundValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (isdrawfail = tradeBill.getBoolean("isdrawfail")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e0d\u80fd\u64cd\u4f5c\u62d2\u6536\u9000\u7968\u3002", (String)"TradeBillRejectRefundValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!(validateEntryTranStatus = (entries = tradeBill.getDynamicObjectCollection("entrys")).stream().anyMatch(TradeBillHelper::canRepayOrRejectRefundDraftEntry))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u5e76\u4e14\u6ca1\u6709\u53d1\u751f \u201c\u62d2\u6536\u9000\u7968\u201d\u6216 \u201c\u5931\u8d25\u91cd\u4ed8\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRejectRefundValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)(source = tradeBill.getString("source")), (CharSequence)"cdm-draftallocate")) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u6765\u6e90\u662f\u7968\u636e\u8c03\u5ea6\uff0c\u4e0d\u80fd\u64cd\u4f5c\u62d2\u6536\u9000\u7968", (String)"TradeBillRejectRefundValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

