/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.errorcode.DraftBillErrorCode;
import kd.tmc.cdm.common.exception.CdmException;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("source");
        selector.add("tradetype");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsor");
        selector.add("tradetype");
        selector.add("bankacct");
        selector.add("deposit");
        selector.add("depositaccount");
        selector.add("depositamount");
        selector.add("pledgeenddate");
        selector.add("recbody");
        selector.add("bankaccount");
        selector.add("subentrys");
        selector.add("e_subbillamount");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("amount");
        selector.add("amount");
        selector.add("payinteramount_bank");
        selector.add("owndiscountinterest");
        selector.add("payinterestamount");
        selector.add("discount_interest");
        selector.add("rptype");
        selector.add("poundage");
        selector.add("discamt");
        selector.add("bankacct");
        selector.add("isequalsplit");
        selector.add("billamt");
        selector.add("billlogid");
        selector.add("isrejectrefundgen");
        selector.add("depositentry.dpbillno");
        selector.add("depositentry.dpdeductamount");
        selector.add("depositentry.dpbillnos_tag");
        selector.add("depositentry.dpbillnos");
        selector.add("depositentry.revenueway");
        selector.add("deducttype");
        selector.add("depositentry.dinterestamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DraftBillErrorCode draftBillErrorCode = new DraftBillErrorCode();
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity data : dataEntity) {
            boolean isReceiveOppNote;
            Object companyId;
            BigDecimal discamt;
            Object amount;
            Set draweracctSet;
            DynamicObject tradeBill = data.getDataEntity();
            DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
            String tradeType = tradeBill.getString("tradetype");
            DynamicObject draftType = tradeBill.getDynamicObject("drafttype");
            String rpType = tradeBill.getString("rptype");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 1 && null == ((DynamicObject)entrys.get(0)).getDynamicObject("draftbill")) {
                throw new CdmException(draftBillErrorCode.ERRORMISSDRAFT());
            }
            Set accepterNameSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getString("acceptername")).collect(Collectors.toSet());
            if (Objects.equals(tradeType, DraftTradeTypeEnum.PAYOFF.getValue()) && accepterNameSet.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipAccepterNameDiff());
            }
            if (tradeBill.getBoolean("deposit") && Objects.equals(tradeType, DraftTradeTypeEnum.PAYOFF.getValue()) && (draweracctSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getString("draweraccountname")).collect(Collectors.toSet())).size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getDrawerAcctDiff());
            }
            HashSet companyIds = new HashSet();
            entrys.stream().filter(o -> !EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("draftbill"))).forEach(v -> companyIds.add(v.getDynamicObject("draftbill").getDynamicObject("company").getPkValue()));
            if (companyIds.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipCompanyDiff());
            }
            if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
                if (tradeBill.getBoolean("deposit")) {
                    BigDecimal depositAmount;
                    if (Objects.isNull(tradeBill.get("depositaccount"))) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAccountNonNull());
                    }
                    if ((depositAmount = tradeBill.getBigDecimal("depositamount")).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAmountGreaterThanZero());
                    }
                    if (depositAmount.compareTo(tradeBill.getBigDecimal("amount")) > 0) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAmountGreaterThanAmount());
                    }
                }
                if (tradeBill.getBoolean("depositdeduct")) {
                    // empty if block
                }
            } else if (DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) {
                HashSet paybillIds = new HashSet(0);
                entrys.stream().map(item -> item.getDynamicObject("draftbill").getLong("id")).forEach(draftBillId -> {
                    List tBillIds = DraftHelper.getBillIds((Long)draftBillId, (boolean)true, (String)"cas_paybill");
                    if (tBillIds.size() < 1 && EmptyUtil.isNoEmpty((String)rpType) && rpType.equals("paybill")) {
                        this.addErrorMessage(data, cdmBizResource.getNoReFund());
                    }
                    paybillIds.addAll(tBillIds);
                });
                if (entrys.size() > 1 && paybillIds.size() > 1) {
                    this.addErrorMessage(data, cdmBizResource.getSamePayBill());
                }
                if (entrys.size() > 1 && "receivebill".equals(rpType)) {
                    this.addErrorMessage(data, cdmBizResource.getNobatchReFund());
                }
            } else if (DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType)) {
                boolean isEqualSplit;
                DynamicObjectCollection subentrys = tradeBill.getDynamicObjectCollection("subentrys");
                DynamicObjectCollection selectEntrys = tradeBill.getDynamicObjectCollection("entrys");
                DynamicObject draftDy = ((DynamicObject)selectEntrys.get(0)).getDynamicObject("draftbill");
                long draftId = draftDy.getLong("id");
                DynamicObject draftBillDyDbNew = QueryServiceHelper.queryOne((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "id", "standardbillamount", "subbillrange", "amount", "availableamount", "subbillendflag", "subbillstartflag", "subbillquantity", "supperbillamount"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftId)});
                BigDecimal selectSubAmount = draftBillDyDbNew.getBigDecimal("amount");
                BigDecimal subAmountAll = new BigDecimal(BigInteger.ZERO);
                for (DynamicObject subEntry : subentrys) {
                    subAmountAll = subAmountAll.add(subEntry.getBigDecimal("e_subbillamount"));
                }
                if (selectSubAmount.compareTo(subAmountAll) != 0) {
                    this.addErrorMessage(data, cdmBizResource.getDraftBillSubAmountWrong());
                }
                if (isEqualSplit = tradeBill.getBoolean("isequalsplit")) {
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)subentrys) || subentrys.size() != 2) {
                        this.addErrorMessage(data, cdmBizResource.getEqualSplitEntrySizeWrong());
                    }
                    BigDecimal splitAmount = ((DynamicObject)subentrys.get(1)).getBigDecimal("e_subbillamount");
                    BigDecimal billAmount = ((DynamicObject)selectEntrys.get(0)).getBigDecimal("billamt");
                    if (billAmount.compareTo(splitAmount) != 0) {
                        this.addErrorMessage(data, cdmBizResource.getEqualSplitAmountWrong());
                    }
                }
            }
            HashSet currencyIds = new HashSet();
            entrys.stream().filter(o -> !EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("draftbill"))).forEach(v -> currencyIds.add(v.getDynamicObject("draftbill").getDynamicObject("currency").getPkValue()));
            if (currencyIds.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipCurrencyDiff());
            }
            if (tradeType.equals(DraftTradeTypeEnum.PAYINTEREST.getValue())) {
                BigDecimal discount_interest;
                DynamicObject bankAccount = tradeBill.getDynamicObject("bankaccount");
                DynamicObject recbody = tradeBill.getDynamicObject("recbody");
                String recBodyUionNum = "";
                String bankAccUionNum = "";
                if (null == bankAccount) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u8d26\u53f7\uff01", (String)"CdmBizResource_123", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject bankAccBebank = bankAccount.getDynamicObject("bank");
                HashSet<Long> pkIds = new HashSet<Long>();
                pkIds.add(recbody.getLong("id"));
                pkIds.add(bankAccBebank.getLong("id"));
                ArrayList<Long> bebankIdList = new ArrayList<Long>(2);
                HashMap<Long, Long> dataToBebankMap = new HashMap<Long, Long>(2);
                DynamicObject[] dyArr = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bebank,union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                Map<Long, List<DynamicObject>> map = Arrays.stream(dyArr).collect(Collectors.groupingBy(e -> e.getLong("id")));
                List<DynamicObject> recbodyList = map.get(recbody.getLong("id"));
                List<DynamicObject> bankAccList = map.get(bankAccBebank.getLong("id"));
                if (EmptyUtil.isNoEmpty(recbodyList)) {
                    DynamicObject recBebank = recbodyList.get(0).getDynamicObject("bebank");
                    if (EmptyUtil.isEmpty((DynamicObject)recBebank)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53d7\u7406\u673a\u6784\u7684\u884c\u540d\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CdmBizResource_104_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    } else {
                        Long recbebankId = recBebank.getLong("id");
                        bebankIdList.add(recbebankId);
                        dataToBebankMap.put(recbody.getLong("id"), recbebankId);
                    }
                }
                if (EmptyUtil.isNoEmpty(bankAccList)) {
                    DynamicObject accBebank = bankAccList.get(0).getDynamicObject("bebank");
                    if (EmptyUtil.isEmpty((DynamicObject)accBebank)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u5f00\u6237\u884c\u7684\u884c\u540d\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CdmBizResource_104_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    } else {
                        Long bebankId = accBebank.getLong("id");
                        bebankIdList.add(bebankId);
                        dataToBebankMap.put(bankAccBebank.getLong("id"), bebankId);
                    }
                }
                DynamicObject[] bebankArr = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", bebankIdList)});
                Map<Long, List<DynamicObject>> bebankMap = Arrays.stream(bebankArr).collect(Collectors.groupingBy(e -> e.getLong("id")));
                Long bankAccBebankId = (Long)dataToBebankMap.get(bankAccBebank.getLong("id"));
                Long recBebankId = (Long)dataToBebankMap.get(recbody.getLong("id"));
                List<DynamicObject> accbakbebankList = bebankMap.get(bankAccBebankId);
                List<DynamicObject> recbebankList = bebankMap.get(recBebankId);
                if (EmptyUtil.isNoEmpty(accbakbebankList)) {
                    bankAccUionNum = accbakbebankList.get(0).getString("union_number");
                }
                if (EmptyUtil.isNoEmpty(recbebankList)) {
                    recBodyUionNum = recbebankList.get(0).getString("union_number");
                }
                if (EmptyUtil.isEmpty((String)recBodyUionNum) || EmptyUtil.isEmpty((String)bankAccUionNum)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u53d7\u7406\u673a\u6784\u6216\u8005\u94f6\u884c\u8d26\u6237\u5f00\u6237\u884c\u7684\u8054\u884c\u53f7\u4e3a\u7a7a\u3002", (String)"CdmBizResource_105", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if ((discount_interest = tradeBill.getBigDecimal("discount_interest")).compareTo(new BigDecimal(BigInteger.ZERO)) <= 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b9e\u4ed8\u8d34\u73b0\u5229\u606f\u91d1\u989d\u53ea\u80fd\u5927\u4e8e\u96f6\u3002", (String)"CdmBizResource_168", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            if (tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue()) || tradeType.equals(DraftTradeTypeEnum.COLLECT.getValue()) || tradeType.equals(DraftTradeTypeEnum.PAYOFF.getValue())) {
                BigDecimal poundage = tradeBill.getBigDecimal("poundage");
                amount = tradeBill.getBigDecimal("amount");
                if (poundage != null && amount != null && poundage.floatValue() > ((BigDecimal)amount).floatValue()) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u624b\u7eed\u8d39\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5408\u8ba1\u91d1\u989d\u3002", (String)"CdmBizResource_76", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            if (tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue()) && ((discamt = tradeBill.getBigDecimal("discamt")) == null || discamt.floatValue() <= 0.0f)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d34\u73b0\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CdmBizResource_78", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
            HashSet draftIds = new HashSet();
            entrys.stream().filter(p -> !EmptyUtil.isEmpty((DynamicObject)p.getDynamicObject("draftbill"))).forEach(v -> draftIds.add(v.getDynamicObject("draftbill").getPkValue()));
            amount = tradeBill.getString("source");
            if (!"endorse".equals(tradeType) || !EmptyUtil.isNoEmpty((Object)(companyId = PayableBillHelp.getCompanyIdByBeen((DynamicObject)tradeBill))) || !(isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)((Long)companyId), (String)"isreceiveoppnote"))) continue;
            String bankAcct = tradeBill.getString("bankacct");
            DynamicObject drafttypedata = BusinessDataServiceHelper.loadSingle((Object)draftType.getLong("id"), (String)"cdm_billtype");
            String billMedium = drafttypedata.getString("billmedium");
            if (EmptyUtil.isEmpty((String)bankAcct) && !"1".equals(billMedium)) continue;
        }
    }
}

