/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.cdm.common.enums.ClaimStatusEnum;
import kd.tmc.cdm.common.helper.BatchQueryHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GenerateVoucherPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(GenerateVoucherPlugin.class);
    private static final String VOUCHERNUM = "vouchernum";
    private static final String CLAIMNOTICEBILLNO = "claimnoticebillno";
    private static final String SURETYREMAINAMOUNT = "suretyremainamount";
    private static final String AMOUNTOFCREDIT = "amountofcredit";
    private static final String CLAIMBLLSTATUS = "claimbllstatus";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    public void setVoucheNumToDb(List<Object> ids, Map<String, String> billNoMap, String entityName) {
        ThreadPools.executeOnceIncludeRequestContext((String)"GenerateVoucherUpdate", () -> {
            List bills = BatchQueryHelper.batchLoad((List)ids, (String)entityName, (String)"id", (String)"id,vouchernum,isvoucher", null);
            for (DynamicObject bill : bills) {
                String billId = String.valueOf(bill.getPkValue());
                if (billNoMap.containsKey(billId)) {
                    String str = (String)billNoMap.get(billId);
                    bill.set(VOUCHERNUM, (Object)str);
                    if (!CasHelper.isNotEmpty((Object)str)) continue;
                    bill.set("isvoucher", (Object)"1");
                    continue;
                }
                bill.set(VOUCHERNUM, (Object)"");
                bill.set("isvoucher", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
        });
    }

    class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
            ArrayList<Object> ids = new ArrayList<Object>(rows.size());
            HashSet claimBillnos = new HashSet(rows.size());
            boolean isContainClaim = false;
            boolean isContainSurety = false;
            boolean isContainCredit = false;
            if (properties.containsKey((Object)GenerateVoucherPlugin.CLAIMNOTICEBILLNO)) {
                isContainClaim = true;
            }
            if (properties.containsKey((Object)GenerateVoucherPlugin.SURETYREMAINAMOUNT)) {
                isContainSurety = true;
            }
            if (properties.containsKey((Object)GenerateVoucherPlugin.AMOUNTOFCREDIT)) {
                isContainCredit = true;
            }
            logger.info("isContainCredit is:" + isContainCredit + ",isContainSurety:" + isContainSurety + ",isContainClaim:" + isContainClaim);
            if (!(isContainCredit || isContainSurety || isContainClaim || properties.containsKey((Object)GenerateVoucherPlugin.VOUCHERNUM))) {
                return rows;
            }
            boolean finalIsContainClaim = isContainClaim;
            rows.forEach(row -> {
                String claimnoticeBillno;
                ids.add(row.getLong("id"));
                if (finalIsContainClaim && EmptyUtil.isNoEmpty((String)(claimnoticeBillno = row.getString(GenerateVoucherPlugin.CLAIMNOTICEBILLNO)))) {
                    claimBillnos.add(claimnoticeBillno);
                }
            });
            if (ids.size() == 0) {
                return rows;
            }
            Map<Object, Object> draftIdAndCreditMap = new HashMap(8);
            Map<Object, Object> draftIdAndSuretyMap = new HashMap(8);
            if (isContainCredit || isContainSurety) {
                DynamicObjectCollection suretybills;
                Set hasSuretyPayDraftIdSet;
                QFilter status_qFilter;
                QFilter isrele_qFilter;
                QFilter source_qFilter;
                Iterator creditUses;
                Set hasCreditPayDraftIdSet;
                DynamicObjectCollection payDraftList = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,creditlimit,paybilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("rptype", "=", (Object)"paybill")});
                if (isContainCredit && EmptyUtil.isNoEmpty(hasCreditPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("creditlimit"))).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid,sourcebillid, realamt", (QFilter[])new QFilter[]{source_qFilter = new QFilter("sourcebillid", "in", hasCreditPayDraftIdSet), isrele_qFilter = new QFilter("isrelease", "=", (Object)"0"), status_qFilter = new QFilter("billstatus", "=", (Object)"C")})))) {
                    draftIdAndCreditMap = creditUses.stream().collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(hasSuretyPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("paybilltype")) && e.getString("paybilltype").contains("guarantee")).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(suretybills = QueryServiceHelper.query((String)"fbd_suretybill", (String)"entry.debtbillid,surplusamount,id", (QFilter[])new QFilter[]{source_qFilter = new QFilter("entry.debtbillid", "in", hasSuretyPayDraftIdSet)})))) {
                    draftIdAndSuretyMap = suretybills.stream().collect(Collectors.groupingBy(e -> e.getLong("entry.debtbillid")));
                }
            }
            Map<Object, Object> claimBillNoAndStautsMap = new HashMap(8);
            if (EmptyUtil.isNoEmpty(claimBillnos)) {
                QFilter claimFilter = new QFilter("billno", "in", claimBillnos);
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id,billno,claimstatus,sourceid", (QFilter[])new QFilter[]{claimFilter});
                claimBillNoAndStautsMap = vouchers.stream().collect(Collectors.toMap(e -> e.getString("billno"), e -> e.getString("claimstatus")));
            }
            QFilter filter = new QFilter("sourcebillid", "in", ids);
            DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
            HashMap<String, List> sourceIdVoucherIdMap = new HashMap<String, List>();
            ArrayList<Long> voucherIds = new ArrayList<Long>(vouchersDaps.size());
            for (DynamicObject dap : vouchersDaps) {
                String sourceBillId = dap.getString("sourcebillid");
                sourceIdVoucherIdMap.computeIfAbsent(sourceBillId, k -> new ArrayList());
                sourceIdVoucherIdMap.computeIfPresent(sourceBillId, (k, v) -> {
                    v.add(dap.getString("voucherid"));
                    return v;
                });
                voucherIds.add(dap.getLong("voucherid"));
            }
            HashMap<String, String> voucherMap = new HashMap<String, String>();
            String entityName = "";
            logger.info("voucherIds is:" + voucherIds.isEmpty());
            if (EmptyUtil.isNoEmpty(voucherIds)) {
                QFilter covFilter = new QFilter("id", "in", voucherIds);
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebill,billno,sourcebilltype,vouchertype.name", (QFilter[])new QFilter[]{covFilter});
                for (DynamicObject voucher : vouchers) {
                    if (StringUtils.hasLength((String)voucher.getString("sourcebilltype"))) {
                        entityName = voucher.getString("sourcebilltype");
                    }
                    String vid = voucher.getString("id");
                    String vb = voucher.getString("vouchertype.name") + " " + voucher.getString("billno");
                    if (voucherMap.containsKey(vid)) {
                        voucherMap.put(vid, (String)voucherMap.get(vid) + "," + vb);
                        continue;
                    }
                    voucherMap.put(vid, vb);
                }
            }
            HashMap<String, String> billNoMap = new HashMap<String, String>();
            for (DynamicObject row2 : rows) {
                List voucherIdList;
                List suretyDyList;
                long draftBillId;
                List creditDyList;
                String claimStatusStr;
                String claimnoticeBillno;
                String vouStr = "";
                String isVoucher = "0";
                if (properties.containsKey((Object)"draftbill")) {
                    String draftNoStr;
                    DynamicObjectCollection draftbills = row2.getDynamicObjectCollection("draftbill");
                    ArrayList<String> draftNo = new ArrayList<String>(20);
                    if (draftbills != null && draftbills.size() > 0) {
                        for (DynamicObject draftbill : draftbills) {
                            DynamicObject draft = draftbill.getDynamicObject("fbasedataid");
                            draftNo.add(draft != null ? draft.getString("draftbillno") : "");
                        }
                    }
                    draftNoStr = (draftNoStr = String.join((CharSequence)",", draftNo)) == null || draftNoStr.length() < 2000 ? draftNoStr : draftNoStr.substring(0, 1999);
                    row2.set("settletnumber", (Object)draftNoStr);
                }
                if (finalIsContainClaim && EmptyUtil.isNoEmpty((String)(claimnoticeBillno = row2.getString(GenerateVoucherPlugin.CLAIMNOTICEBILLNO))) && EmptyUtil.isNoEmpty((String)(claimStatusStr = (String)claimBillNoAndStautsMap.get(claimnoticeBillno)))) {
                    String name = ClaimStatusEnum.getName((String)claimStatusStr);
                    row2.set(GenerateVoucherPlugin.CLAIMBLLSTATUS, (Object)name);
                }
                if (isContainCredit && EmptyUtil.isNoEmpty(draftIdAndCreditMap) && draftIdAndCreditMap.size() > 0 && EmptyUtil.isNoEmpty((Object)(creditDyList = (List)draftIdAndCreditMap.get(draftBillId = row2.getLong("id"))))) {
                    DynamicObject creditDy = (DynamicObject)creditDyList.get(0);
                    BigDecimal realamt = creditDy.getBigDecimal("realamt");
                    row2.set(GenerateVoucherPlugin.AMOUNTOFCREDIT, (Object)realamt);
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(draftIdAndSuretyMap) && draftIdAndSuretyMap.size() > 0 && EmptyUtil.isNoEmpty((Object)(suretyDyList = (List)draftIdAndSuretyMap.get(draftBillId = row2.getLong("id"))))) {
                    DynamicObject suretyDy = (DynamicObject)suretyDyList.get(0);
                    BigDecimal surplusamount = suretyDy.getBigDecimal("surplusamount");
                    row2.set(GenerateVoucherPlugin.SURETYREMAINAMOUNT, (Object)surplusamount);
                }
                if ((voucherIdList = (List)sourceIdVoucherIdMap.get(String.valueOf(row2.getPkValue()))) == null || voucherIdList.size() == 0) {
                    row2.set(GenerateVoucherPlugin.VOUCHERNUM, (Object)vouStr);
                    row2.set("isvoucher", (Object)isVoucher);
                    billNoMap.put(String.valueOf(row2.getPkValue()), vouStr);
                    continue;
                }
                for (String voucherId : voucherIdList) {
                    if (!voucherMap.containsKey(voucherId)) continue;
                    if (CasHelper.isEmpty((Object)vouStr)) {
                        vouStr = (String)voucherMap.get(voucherId);
                        continue;
                    }
                    vouStr = vouStr + "," + (String)voucherMap.get(voucherId);
                }
                if (vouStr != null && vouStr.length() > 255) {
                    vouStr = vouStr.substring(0, 255);
                }
                if (CasHelper.isNotEmpty((Object)vouStr)) {
                    isVoucher = "1";
                }
                row2.set(GenerateVoucherPlugin.VOUCHERNUM, (Object)vouStr);
                row2.set("isvoucher", (Object)isVoucher);
                billNoMap.put(String.valueOf(row2.getPkValue()), vouStr);
            }
            if (billNoMap.size() > 0 && !CasHelper.isEmpty((Object)entityName)) {
                GenerateVoucherPlugin.this.setVoucheNumToDb(ids, billNoMap, entityName);
            }
            return rows;
        }
    }
}

