/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.allocation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAllocationEdit
extends AbstractBillPlugIn {
    public static final String SELECT_DRAFT_CLOSE_CALL_BACK = "select_draft_close_call_back";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setBillPoolListener();
        this.setOutCompanyListener();
        this.setInCompanyListener();
        this.setDraftBillListener();
        this.setInCompanyAccListener();
        this.setCreatePoolOrgAccListener();
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    private void setDraftBillListener() {
        BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("e_draftbill");
        draftBillEdit.addBeforeF7SelectListener(evt -> {
            String errorMessage = this.checkBeforeSelectDraft();
            if (errorMessage.length() > 0) {
                this.getView().showTipNotification(errorMessage);
                evt.setCancel(true);
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.getListFilterParameter().setQFilters(this.getDraftQFilters());
            parameter.setCaption(this.getDraftBillCaption());
            evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_DRAFT_CLOSE_CALL_BACK));
        });
    }

    private void setInCompanyListener() {
        BasedataEdit inCompanyEdit = (BasedataEdit)this.getControl("incompany");
        inCompanyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
            if (Objects.isNull(billPool)) {
                evt.setCancel(true);
                this.getView().showTipNotification(this.getBillPoolMustInputTips());
                return;
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            Object bizType = this.getModel().getValue("biztype");
            if (Objects.equals(bizType, DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue()) || Objects.equals(bizType, DraftAllocateBizTypeEnum.ALLOCATE.getValue())) {
                QFilter outCompanyFilter = new QFilter("id", "in", this.getBillPoolMemberCompanyIds());
                parameter.getListFilterParameter().setFilter(outCompanyFilter);
            }
        });
    }

    private void setInCompanyAccListener() {
        BasedataEdit inCompanyEdit = (BasedataEdit)this.getControl("inaccount");
        inCompanyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject inCompany = this.getModel().getDataEntity().getDynamicObject("incompany");
            if (Objects.isNull(inCompany)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u5165\u8d44\u91d1\u7ec4\u7ec7", (String)"DraftAllocationEdit_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter companyFilter = new QFilter("acctstatus", "not in", (Object)new String[]{"closed", "changing"});
            QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)inCompany.getLong("id"));
            parameter.getListFilterParameter().setFilter(companyFilter.and(accountAuthAssignFilter));
        });
    }

    private void setCreatePoolOrgAccListener() {
        BasedataEdit createCompanyEdit = (BasedataEdit)this.getControl("createpoolaccount");
        createCompanyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject createCompany = this.getModel().getDataEntity().getDynamicObject("company");
            if (Objects.isNull(createCompany)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5efa\u6c60\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftAllocationEdit_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            Object[] eleDirecSetList = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,company,defaultaccount", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)createCompany.getLong("id"))});
            if (!EmptyUtil.isNoEmpty((Object[])eleDirecSetList)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5efa\u6c60\u8d44\u91d1\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u7535\u7968\u76f4\u8fde\u8d26\u53f7\u3002", (String)"DraftAllocationEdit_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            Set defaultaccountIds = Arrays.stream(eleDirecSetList).map(e -> e.getDynamicObject("defaultaccount").getLong("id")).collect(Collectors.toSet());
            QFilter inCompanyAccFilter = new QFilter("id", "in", defaultaccountIds);
            parameter.getListFilterParameter().setFilter(inCompanyAccFilter);
        });
    }

    private Set<Object> getBillPoolMemberCompanyIds() {
        DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
        return billPool.getDynamicObjectCollection("entryentity").stream().filter(row -> Objects.nonNull(row.getDynamicObject("e_company"))).map(row -> row.getDynamicObject("e_company").getPkValue()).collect(Collectors.toSet());
    }

    private String getBillPoolMustInputTips() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7968\u636e\u6c60\u3002", (String)"DraftAllocationEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
    }

    private void setOutCompanyListener() {
        BasedataEdit outCompanyEdit = (BasedataEdit)this.getControl("outcompany");
        outCompanyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
            if (Objects.isNull(billPool)) {
                evt.setCancel(true);
                this.getView().showTipNotification(this.getBillPoolMustInputTips());
                return;
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            Object bizType = this.getModel().getValue("biztype");
            if (Objects.equals(bizType, DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue()) || Objects.equals(bizType, DraftAllocateBizTypeEnum.ALLOCATE.getValue())) {
                QFilter outCompanyFilter = new QFilter("id", "in", this.getBillPoolMemberCompanyIds());
                parameter.getListFilterParameter().setFilter(outCompanyFilter);
            }
        });
    }

    private void setBillPoolListener() {
        BasedataEdit billPool = (BasedataEdit)this.getControl("billpool");
        billPool.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = RequestContext.get().getCurrUserId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_draftallocation", (String)"47150e89000000ac");
            QFilter companyFilter = new QFilter("company.id", "in", (Object)authOrgIds);
            QFilter enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            parameter.getListFilterParameter().setFilter(companyFilter.and(enableFilter));
        });
    }

    public void afterCreateNewData(EventObject e) {
        Object businessType = this.getView().getFormShowParameter().getCustomParam("biztype");
        this.getModel().setValue("biztype", businessType);
        this.getModel().setValue("company", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        String name = e.getProperty().getName();
        if (Objects.equals(name, "billpool")) {
            this.clearField("incompany", "outcompany");
            this.fillByBillPool(newValue);
        } else if (Objects.equals(name, "outcompany")) {
            this.fillByOutCompany(newValue);
        } else if (Objects.equals(name, "incompany")) {
            this.fillByInCompany(newValue);
        } else if (Objects.equals(name, "e_draftbill")) {
            this.setBillHeader();
        }
    }

    private void fillByInCompany(Object newValue) {
        DynamicObject newInCompany = (DynamicObject)newValue;
        DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
        if (Objects.nonNull(newInCompany)) {
            Object bizType = this.getModel().getValue("biztype");
            if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue(), bizType)) {
                if (Objects.equals(billPool.getDynamicObject("company").getPkValue(), newInCompany.getPkValue())) {
                    this.getView().showTipNotification(this.getOnlySelectTips());
                    this.getModel().setValue("incompany", null);
                }
            } else if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE.getValue(), bizType)) {
                DynamicObject outCompany = this.getModel().getDataEntity().getDynamicObject("outcompany");
                if (Objects.nonNull(outCompany) && Objects.equals(outCompany.getPkValue(), newInCompany.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e0e\u8c03\u51fa\u8d44\u91d1\u7ec4\u7ec7\u76f8\u540c\u3002", (String)"DraftAllocationEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("incompany", null);
                }
                if (Objects.equals(billPool.getDynamicObject("company").getPkValue(), newInCompany.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u7968\u636e\u5f52\u96c6\u529f\u80fd\u3002", (String)"DraftAllocationEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("incompany", null);
                }
            }
        }
    }

    private String getOnlySelectTips() {
        return ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6c60\u6210\u5458\u7ec4\u7ec7\u3002", (String)"DraftAllocationEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
    }

    private void clearField(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    private void fillByOutCompany(Object newValue) {
        DynamicObject newOutCompany = (DynamicObject)newValue;
        DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
        if (Objects.nonNull(newOutCompany)) {
            Object bizType = this.getModel().getValue("biztype");
            if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue(), bizType)) {
                if (Objects.equals(billPool.getDynamicObject("company").getPkValue(), newOutCompany.getPkValue())) {
                    this.getView().showTipNotification(this.getOnlySelectTips());
                    this.getModel().setValue("outcompany", null);
                }
            } else if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE.getValue(), bizType)) {
                DynamicObject inCompany = this.getModel().getDataEntity().getDynamicObject("incompany");
                if (Objects.nonNull(inCompany) && Objects.equals(inCompany.getPkValue(), newOutCompany.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e0e\u8c03\u5165\u8d44\u91d1\u7ec4\u7ec7\u76f8\u540c\u3002", (String)"DraftAllocationEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("outcompany", null);
                }
                if (Objects.equals(billPool.getDynamicObject("company").getPkValue(), newOutCompany.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u7968\u636e\u4e0b\u62e8\u529f\u80fd\u3002", (String)"DraftAllocationEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("outcompany", null);
                }
            }
        }
    }

    private void fillByBillPool(Object newValue) {
        this.getModel().setValue("company", newValue == null ? null : ((DynamicObject)newValue).getDynamicObject("company"));
        Object bizType = this.getModel().getValue("biztype");
        if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue(), bizType)) {
            this.getModel().setValue("outcompany", newValue == null ? null : ((DynamicObject)newValue).getDynamicObject("company"));
        } else if (Objects.equals(DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue(), bizType)) {
            this.getModel().setValue("incompany", newValue == null ? null : ((DynamicObject)newValue).getDynamicObject("company"));
        }
        this.getModel().setValue("dispatchrule", newValue == null ? null : ((DynamicObject)newValue).getString("dispatchrule"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals(operateKey, "selectdraft") || Objects.equals("newentry", operateKey)) {
            String errorMessage = this.checkBeforeSelectDraft();
            if (errorMessage.length() > 0) {
                this.getView().showTipNotification(errorMessage);
                args.setCancel(true);
            }
        } else if (Objects.equals(operateKey, "viewback")) {
            EntryGrid entryBank = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryBank.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u5f55\u6570\u636e\u67e5\u770b\u80cc\u9762\u4fe1\u606f\u3002", (String)"DraftAllocationEdit_14", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (Arrays.asList("save", "submit").contains(operateKey) && !this.checkDoOperation()) {
            args.setCancel(true);
        }
    }

    private boolean checkDoOperation() {
        boolean isSameCompany;
        DynamicObject incompany = this.getModel().getDataEntity().getDynamicObject("incompany");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (incompany != null && entryentity != null && entryentity.size() > 0 && (isSameCompany = entryentity.stream().filter(item -> Objects.nonNull(item.getDynamicObject("e_draftbill")) && Objects.nonNull(item.getDynamicObject("e_draftbill").getDynamicObject("company")) && Objects.equals(incompany.getPkValue(), item.getDynamicObject("e_draftbill").getDynamicObject("company").getPkValue())).findFirst().isPresent())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u80cc\u4e66\u7968\u636e\u7684\u8c03\u51fa\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e0e\u8c03\u5165\u8d44\u91d1\u7ec4\u7ec7\u76f8\u540c\u3002", (String)"DraftAllocationEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String checkBeforeSelectDraft() {
        DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
        if (Objects.isNull(billPool)) {
            return this.getBillPoolMustInputTips();
        }
        return "";
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (Objects.equals(evt.getItemKey(), "failcancel")) {
            this.doOperation(evt, "failcancel");
        } else if (Objects.equals(evt.getItemKey(), "failresend")) {
            this.doOperation(evt, "failresend");
        }
    }

    private void doOperation(BeforeItemClickEvent evt, String opKey) {
        Set<Long> rowIds = this.getSelectEntryRowIds();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("selectRowIds", SerializationUtils.toJsonString(rowIds));
        OperationResult result = this.getView().invokeOperation(opKey, operateOption);
        if (!result.isSuccess()) {
            evt.setCancel(true);
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    private Set<Long> getSelectEntryRowIds() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> rowIds = new HashSet<Long>(selectRows.length);
        for (int selectRow : selectRows) {
            rowIds.add((Long)((DynamicObject)entryEntity.get(selectRow)).getPkValue());
        }
        return rowIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (Objects.equals("selectdraft", evt.getOperateKey())) {
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
            param.setShowTitle(false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_DRAFT_CLOSE_CALL_BACK));
            param.setCaption(this.getDraftBillCaption());
            param.getListFilterParameter().setQFilters(this.getDraftQFilters());
            this.getView().showForm((FormShowParameter)param);
        } else if (Objects.equals("viewback", evt.getOperateKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setAppId("cdm");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId("cdm_draftbillback");
            parameter.setCustomParam("draftBillId", this.getDraftBillId());
            this.getView().showForm(parameter);
        }
    }

    private String getDraftBillCaption() {
        return ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"DraftAllocationEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
    }

    private List<QFilter> getDraftQFilters() {
        DynamicObject inCompany;
        DynamicObject outCompany;
        DynamicObject draftAllocation;
        DynamicObject currency;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter statusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
        qFilters.add(statusFilter);
        DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
        if (Objects.nonNull(billPool)) {
            QFilter billPoolFilter = new QFilter("billpool", "=", billPool.getPkValue());
            qFilters.add(billPoolFilter);
        }
        if (Objects.nonNull(currency = (draftAllocation = this.getModel().getDataEntity()).getDynamicObject("currency"))) {
            qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        }
        if (Objects.nonNull(outCompany = draftAllocation.getDynamicObject("outcompany"))) {
            qFilters.add(new QFilter("company", "=", outCompany.getPkValue()));
        }
        if (Objects.nonNull(inCompany = draftAllocation.getDynamicObject("incompany"))) {
            qFilters.add(new QFilter("company", "!=", inCompany.getPkValue()));
        }
        qFilters.add(new QFilter("availableamount", ">", (Object)0));
        qFilters.add(new QFilter("poollockstatus", "=", (Object)"0"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List selectedDaftIds = entryEntity.stream().filter(row -> Objects.nonNull(row.getDynamicObject("e_draftbill"))).map(d -> d.getDynamicObject("e_draftbill").getPkValue()).collect(Collectors.toList());
        if (!selectedDaftIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", selectedDaftIds));
        }
        qFilters.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        return qFilters;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (actionId.equals(SELECT_DRAFT_CLOSE_CALL_BACK)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (EmptyUtil.isEmpty((Collection)rows)) {
                return;
            }
            List selectPks = rows.stream().filter(o -> Objects.nonNull(o.getPrimaryKeyValue())).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "amount", "currency"), (QFilter[])new QFilter[]{new QFilter("id", "in", selectPks)});
            this.checkCurrency(drafts);
            this.batchFillEntry(drafts);
        }
    }

    private void checkCurrency(DynamicObject[] drafts) {
        Set currencyIds = Arrays.stream(drafts).filter(d -> Objects.nonNull(d.getDynamicObject("currency"))).map(d -> d.getDynamicObject("currency").getPkValue()).collect(Collectors.toSet());
        if (currencyIds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u7968\u636e\u3002", (String)"DraftAllocationEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void batchFillEntry(DynamicObject[] drafts) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.forceClearNoDataRow();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("e_draftbill", new Object[0]);
        vs.addField("e_subbillamt", new Object[0]);
        for (int i = 0; i < drafts.length; ++i) {
            if (i == 0) {
                this.getModel().setValue("currency", drafts[i].get("currency"));
            }
            vs.addRow(new Object[]{drafts[i].getPkValue(), drafts[i].getBigDecimal("amount")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        this.setBillHeader();
    }

    private void setBillHeader() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BigDecimal amountCount = entryEntity.stream().filter(x -> Objects.nonNull(x.getDynamicObject("e_draftbill"))).map(d -> d.getDynamicObject("e_draftbill").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        long count = entryEntity.stream().filter(d -> Objects.nonNull(d.getDynamicObject("e_draftbill"))).count();
        this.getModel().setValue("amount", (Object)amountCount);
        this.getModel().setValue("draftcount", (Object)count);
        if (entryEntity.isEmpty()) {
            this.getModel().setValue("currency", null);
        }
    }

    private Object getDraftBillId() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryBank.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject selectRow = (DynamicObject)entryEntity.get(selectRows[0]);
        return selectRow.getDynamicObject("e_draftbill").getPkValue();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setBillHeader();
    }
}

