/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.allocation;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.constant.DBRouteConst;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class DraftAllocationList
extends AbstractTmcBillBaseList {
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"billpool.")) {
            StringBuilder selectStr = new StringBuilder("SELECT A.fbillpoolid as billpoolid FROM t_cdm_draftalloc A WHERE A.fbillpoolid != 0 ");
            Set billPoolIds = (Set)DB.query((DBRoute)DBRouteConst.TMC, (String)selectStr.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet resultSet) throws Exception {
                    HashSet<Long> ids = new HashSet<Long>(8);
                    while (resultSet.next()) {
                        if (EmptyUtil.isEmpty((Long)resultSet.getLong(1))) continue;
                        ids.add(resultSet.getLong(1));
                    }
                    return ids;
                }
            });
            QFilter billPoolFilter = new QFilter("id", "in", (Object)billPoolIds);
            List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"cdm_draftallocation", (String)"47150e89000000ac");
            QFilter companyFilter = new QFilter("company", "in", (Object)authIdList);
            args.getQFilters().addAll(Arrays.asList(billPoolFilter, companyFilter));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("allocatedown".equals(operateKey)) {
            this.showBill(DraftAllocateBizTypeEnum.ALLOCATE_DOWN, OperationStatus.ADDNEW, null);
        } else if ("allocateup".equals(operateKey)) {
            this.showBill(DraftAllocateBizTypeEnum.ALLOCATE_UP, OperationStatus.ADDNEW, null);
        } else if ("allocate".equals(operateKey)) {
            this.showBill(DraftAllocateBizTypeEnum.ALLOCATE, OperationStatus.ADDNEW, null);
        }
    }

    private void showBill(DraftAllocateBizTypeEnum allocateBizTypeEnum, OperationStatus operationStatus, Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId("cdm");
        parameter.setStatus(operationStatus);
        parameter.setFormId("cdm_draftallocation");
        parameter.setCustomParam("biztype", (Object)allocateBizTypeEnum.getValue());
        parameter.setCaption(allocateBizTypeEnum.getName());
        parameter.setPkId(pkId);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

