/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.basedata;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;

public class ElectricTicDirConSetEdit
extends AbstractBasePlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (name) {
            case "defaultaccount": {
                if (newValue == null) {
                    return;
                }
                Object bankInterface = ((DynamicObject)newValue).get("bankinterface");
                Object bankId = ((DynamicObject)newValue).get("bank.id");
                DynamicObject bankInfo = BusinessDataServiceHelper.loadSingle((Object)bankId, (String)"bd_finorginfo");
                Object bankName = bankInfo.get("bebank.name");
                this.getModel().setValue("bankinterface", bankInterface);
                this.getModel().setValue("bankname", bankName);
                break;
            }
            case "directconnchannel": {
                this.getModel().setValue("defaultaccount", null);
                break;
            }
            case "company": {
                if (oldValue == null || oldValue.equals(newValue)) break;
                this.getModel().setValue("directconnchannel", null);
                this.getModel().setValue("defaultaccount", null);
                break;
            }
            case "finorgtype": {
                String finOrgType = (String)this.getModel().getValue("finorgtype");
                if ("0".equals(finOrgType)) break;
                this.getModel().setValue("directconnchannel", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.ticketAccountF7Filter();
    }

    private void ticketAccountF7Filter() {
        BasedataEdit accountObj = (BasedataEdit)this.getControl("defaultaccount");
        accountObj.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("company");
            DynamicObject channelObj = (DynamicObject)this.getModel().getValue("directconnchannel");
            String finOrgType = (String)this.getModel().getValue("finorgtype");
            if (Objects.isNull(orgObj)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ElectricTicDirConSetEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if ("0".equals(finOrgType) && Objects.isNull(channelObj)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76f4\u8fde\u6e20\u9053\u3002", (String)"ElectricTicDirConSetEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long orgID = Long.parseLong(orgObj.getPkValue().toString());
            QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
            QFilter finOrgTypeFilter = new QFilter("bank.finorgtype.type", "=", (Object)finOrgType);
            QFilter isEBFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            QFilter beBankFilter = new QFilter("bebankfunc", "like", (Object)("%" + BankFuncEnum.ECD.getValue() + "%"));
            if ("0".equals(finOrgType)) {
                Long channelId = channelObj.getLong("id");
                accountAuthAssignFilter.and(new QFilter("bank.bank_cate.id", "=", (Object)channelId));
            }
            showPara.getListFilterParameter().setQFilters(Arrays.asList(accountAuthAssignFilter, finOrgTypeFilter, isEBFilter, beBankFilter));
        });
    }
}

