/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class RecBillMatchRuleEdit
extends AbstractBasePlugIn {
    private static final String CALLBACK_KEY_1 = "back_matchplan";
    private static final String NON_FIELDS = "non_fields";
    private static final String CAS_REC_BILL = "cas_recbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_matchplan", "e_detailcondition", "e_bizcondition"});
        this.fillOrgF7();
        this.authorizedCompany();
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_recbill_matchrule", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            DynamicObjectCollection uEntryDOC = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (!ObjectUtils.isEmpty((Object)uEntryDOC)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntryDOC.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntryDOC.get(i);
                    if (i == row || ObjectUtils.isEmpty((Object)uEntryDO) || ObjectUtils.isEmpty((Object)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }

    private void authorizedCompany() {
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_ele_notice_rule", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("matchentity");
        switch (key) {
            case "e_matchplan": {
                Object value = model.getValue("e_matchplan_real_TAG", index);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cdm_matchplan");
                showParameter.setCustomParam("biztype", (Object)"rec");
                if (value != null) {
                    showParameter.setCustomParam("matchplanInfo", value);
                }
                showParameter.setCustomParam("matchByEntry", (Object)false);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_1));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
            case "e_detailcondition": {
                this.showCondition(index, "detailcondition_real", this.getPageCache().get("detailcondition_real"), "cdm_receivablebill");
                break;
            }
            case "e_bizcondition": {
                this.showCondition(index, "bizcondition_real", this.getPageCache().get("bizcondition_real"), CAS_REC_BILL);
            }
        }
    }

    private void showCondition(int rowIndex, String sourceCtrlKey, String fieldNodes, String entity) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_apply_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (CALLBACK_KEY_1.equals(actionId)) {
            if (returnData != null) {
                IDataModel model = this.getModel();
                int index = model.getEntryCurrentRowIndex("matchentity");
                Map data = (Map)returnData;
                String res = (String)data.get("matchplanInfo");
                String res2 = (String)data.get("displayInfo");
                if (res2.length() > 1024) {
                    model.setValue("e_matchplan", (Object)res2.substring(0, 1024), index);
                } else {
                    model.setValue("e_matchplan", (Object)res2, index);
                }
                model.setValue("e_matchplan_real_TAG", (Object)res, index);
            }
        } else if ("detailcondition_real".equals(actionId)) {
            this.receiveExpressionSet(e, "matchentity", "detailcondition_real", "e_detailcondition");
        } else if ("bizcondition_real".equals(actionId)) {
            this.receiveExpressionSet(e, "matchentity", "bizcondition_real", "e_bizcondition");
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue(descFldKey, (Object)desp, row);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int entryentity = valueSet[0].getRowIndex();
        switch (propName) {
            case "e_detailcondition": {
                if (!ObjectUtils.isEmpty((Object)newValue) && !"".equals(newValue)) break;
                this.getModel().setValue("detailcondition_real", null, entryentity);
                this.getModel().setValue("detailcondition_real_TAG", null, entryentity);
                break;
            }
            case "e_bizcondition": {
                if (!ObjectUtils.isEmpty((Object)newValue) && !"".equals(newValue)) break;
                this.getModel().setValue("bizcondition_real", null, entryentity);
                this.getModel().setValue("bizcondition_real_TAG", null, entryentity);
                break;
            }
            case "e_matchbyentry": {
                this.getModel().setValue("e_matchplan", null, entryentity);
                this.getModel().setValue("e_matchplan_real", null, entryentity);
                this.getModel().setValue("e_matchplan_real_tag", null, entryentity);
            }
        }
    }
}

