/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BillPoolList
extends AbstractTmcBillBaseList {
    public static final String DELETE_CONFIRM_ACTION = "deleteConfirmAction";
    public static final String BILLLISTAP = "billlistap";
    public static final String CARDBILLLIST = "cardbilllist";
    public static final String TMC_CDM_FORMPLUGIN = "tmc-cdm-formplugin";
    private static final Log log = LogFactory.getLog(BillPoolList.class);

    public void setFilter(SetFilterEvent e) {
        log.info("setFilter start");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("company", "in", this.getAuthorizedBankOrgId()));
        e.setCustomQFilters(filterList);
        log.info("setFilter end");
    }

    private List<Long> getAuthorizedBankOrgId() {
        ArrayList<Long> accountList = new ArrayList();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        accountList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_billpool", (String)"47150e89000000ac");
        log.info("accountList is:" + SerializationUtils.toJsonString(accountList));
        return accountList;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final BillList billListap = (BillList)this.getControl(BILLLISTAP);
        BillList cardBillList = (BillList)this.getControl(CARDBILLLIST);
        if (billListap == null) {
            return;
        }
        if (cardBillList == null) {
            return;
        }
        cardBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRow selectCar = evt.getCurrentListSelectedRow();
                if (selectCar != null) {
                    Object primaryKey = selectCar.getPrimaryKeyValue();
                    billListap.setFilter(new QFilter("id", "=", primaryKey));
                    billListap.clearSelection();
                    billListap.refresh();
                }
            }
        });
        cardBillList.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            Object selectRowPkValue = ((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId();
            billListap.setFilter(new QFilter("id", "=", selectRowPkValue));
            billListap.refresh();
            if ("name".equals(fieldName)) {
                showParameter.setFormId("cdm_billpool");
                showParameter.setAppId("cdm");
                showParameter.setPkId(selectRowPkValue);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        });
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        log.info("filterColumnSetFilter start");
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"company.")) {
            args.getQFilters().addAll(this.getCompanyFilter());
        }
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"bank.")) {
            args.getQFilters().addAll(this.getBankFilter());
        }
        log.info("filterColumnSetFilter end");
    }

    private List<QFilter> getCompanyFilter() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"company", (QFilter[])new QFilter("company.id", "in", this.getAuthorizedBankOrgId()).toArray());
        Set companyIds = Arrays.stream(load).filter(d -> d.getDynamicObject("company") != null).map(d -> (Long)d.getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
        log.info("getCompanyFilter companyIds:" + SerializationUtils.toJsonString(companyIds));
        return Collections.singletonList(new QFilter("id", "in", companyIds));
    }

    private List<QFilter> getBankFilter() {
        QFilter companyFilter = new QFilter("company", "in", this.getAuthorizedBankOrgId());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"bank", (QFilter[])companyFilter.and(new QFilter("bank.id", "!=", (Object)0)).toArray());
        Set bankIds = Arrays.stream(load).filter(d -> d.getDynamicObject("bank") != null).map(d -> (Long)d.getDynamicObject("bank").getPkValue()).collect(Collectors.toSet());
        log.info("getBankFilter bankIds:" + SerializationUtils.toJsonString(bankIds));
        return Collections.singletonList(new QFilter("id", "in", bankIds));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billListap = (BillList)this.getControl(BILLLISTAP);
        BillList cardBillList = (BillList)this.getControl(CARDBILLLIST);
        if (billListap == null) {
            return;
        }
        if (cardBillList == null) {
            return;
        }
        List<String> propertyList = this.getFilterProperties(e);
        log.info("propertyList is:" + SerializationUtils.toJsonString(propertyList));
        if (propertyList.contains("id")) {
            return;
        }
        Object[] primaryKeyValues = billListap.getCurrentListAllRowCollection().getPrimaryKeyValues();
        log.info("primaryKeyValues is:" + SerializationUtils.toJsonString((Object)primaryKeyValues));
        cardBillList.setFilter(new QFilter("id", "in", (Object)primaryKeyValues));
        cardBillList.refresh();
        cardBillList.selectRows(0);
    }

    private List<String> getFilterProperties(EventObject e) {
        IListModel listModel;
        FilterParameter filterParameter;
        List<String> propertyList = new ArrayList<String>();
        if (e.getSource() instanceof BillList && (filterParameter = ((ListModel)(listModel = ((BillList)e.getSource()).getListModel())).getFilterParameter()) != null) {
            List qFilters = filterParameter.getQFilters();
            propertyList = qFilters.stream().map(QFilter::getProperty).collect(Collectors.toList());
        }
        return propertyList;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        log.info("filterContainerSearchClick start:");
        super.filterContainerSearchClick(args);
        BillList cardBillList = (BillList)this.getControl(CARDBILLLIST);
        if (Objects.nonNull(cardBillList)) {
            cardBillList.clearSelection();
            cardBillList.selectRows(0);
        }
        log.info("filterContainerSearchClick end:");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)formOperate.getOperateKey())) {
            BillList cardBillList = (BillList)this.getControl(CARDBILLLIST);
            cardBillList.clearSelection();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult enableResult;
        super.afterDoOperation(evt);
        BillList cardBillList = (BillList)this.getControl(CARDBILLLIST);
        BillList billListap = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = cardBillList.getSelectedRows();
        if (Objects.equals(evt.getOperateKey(), "carddelete")) {
            if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"BillPoolList_0", (String)TMC_CDM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(DELETE_CONFIRM_ACTION, (IFormPlugin)this));
            }
        } else if (Objects.equals(evt.getOperateKey(), "carddisable")) {
            OperationResult disableResult;
            if (!CollectionUtils.isEmpty((Collection)selectedRows) && (disableResult = TmcOperateServiceHelper.execOperate((String)"disable", (String)"cdm_billpool", (Object[])new Object[]{selectedRows.get(0).getPrimaryKeyValue()}, (OperateOption)OperateOption.create())).isSuccess()) {
                billListap.refresh();
                cardBillList.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BillPoolList_1", (String)TMC_CDM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (Objects.equals(evt.getOperateKey(), "cardenable") && !CollectionUtils.isEmpty((Collection)selectedRows) && (enableResult = TmcOperateServiceHelper.execOperate((String)"enable", (String)"cdm_billpool", (Object[])new Object[]{selectedRows.get(0).getPrimaryKeyValue()}, (OperateOption)OperateOption.create())).isSuccess()) {
            billListap.refresh();
            cardBillList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BillPoolList_2", (String)TMC_CDM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BillList cardBillList;
        Object primaryKeyValue;
        OperationResult operationResult;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)DELETE_CONFIRM_ACTION) && MessageBoxResult.Yes == result && (operationResult = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cdm_billpool", (Object[])new Object[]{primaryKeyValue = (cardBillList = (BillList)this.getControl(CARDBILLLIST)).getSelectedRows().get(0).getPrimaryKeyValue()}, (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().invokeOperation("refresh");
            cardBillList.refresh();
            cardBillList.selectRows(0);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BillPoolList_3", (String)TMC_CDM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }
}

