/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpool;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.ExpressionType;

public class IntoPoolRuleEdit
extends AbstractBillPlugIn {
    public static final String CDM_INTOPOOLRULE = "cdm_intopoolrule";
    public static final String CDM_APPLY_CONDITION = "cdm_apply_condition";
    public static final String SOURCEBILL = "cdm_receivablebill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_applicablecondition"});
        this.initF7();
    }

    private void initF7() {
        this.initBillPool();
    }

    private void initBillPool() {
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"pool", beforeF7SelectEvent -> new QFilter("company", "in", this.getAuthorizedBankOrgId()));
    }

    private List<Long> getAuthorizedBankOrgId() {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        return TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_billpool", (String)"47150e89000000ac");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"pool")) {
            model.deleteEntryData("entryentity_org");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject pool = dataEntity.getDynamicObject("pool");
            if (pool == null) {
                model.deleteEntryData("entryentity_org");
                return;
            }
            DynamicObject createPoolCompany = pool.getDynamicObject("company");
            DynamicObjectCollection poolCompany = pool.getDynamicObjectCollection("entryentity");
            for (int i = 0; i <= poolCompany.size(); ++i) {
                int row = this.getModel().createNewEntryRow("entryentity_org");
                if (i == 0) {
                    model.setValue("u_companyid", createPoolCompany.getPkValue(), row);
                    continue;
                }
                model.setValue("u_companyid", ((DynamicObject)poolCompany.get(i - 1)).getDynamicObject("e_company").getPkValue(), row);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control con = (Control)evt.getSource();
        switch (key = con.getKey()) {
            case "e_applicablecondition": {
                String fieldJson = ExpressionFromHelper.getSourceBillFieldNode((String)SOURCEBILL, (String)"e_datafilter_tag", (ExpressionType)ExpressionType.Condition, (boolean)false, null, (AbstractFormPlugin)this);
                ExpressionFromHelper.openExpressionForm((String)CDM_APPLY_CONDITION, (String)SOURCEBILL, (String)((String)this.getModel().getValue("e_datafilter_tag")), (String)fieldJson, (String)"e_datafilter_tag", (AbstractFormPlugin)this);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("save")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long pkValue = dataEntity.getLong("id");
            DynamicObject[] intoPoolRules = BusinessDataServiceHelper.load((String)CDM_INTOPOOLRULE, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)pkValue)});
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name == null) {
                return;
            }
            String name1 = name.getLocaleValue();
            for (DynamicObject dy : intoPoolRules) {
                String str = dy.getLocaleString("name").getLocaleValue();
                if (!StringUtils.equals((CharSequence)str, (CharSequence)name1)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"IntoPoolRuleEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"e_datafilter_tag", (CharSequence)actionId)) {
            ExpressionFromHelper.dealCallbackOfCloseForm((ClosedCallBackEvent)closedCallBackEvent, (String)"e_applicablecondition", (String)"e_datafilter_tag", (AbstractFormPlugin)this);
        }
    }
}

