/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillEndorseTypeEnum;
import kd.tmc.fbp.common.enums.BooleanEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class DraftBillBackEdit
extends AbstractFormPlugin {
    private static final String LABELAP_1 = "labelap1";
    private static final String LABELAP_2 = "labelap2";
    private static final String LABELAP_3 = "labelap3";
    private static final String LABELAP_4 = "labelap4";
    private static final String LABELAP_5 = "labelap5";
    private static final String LABELAP_6 = "labelap6";
    private static final String LABELAP_7 = "labelap7";
    private static final String LABELAP_8 = "labelap8";

    public void afterCreateNewData(EventObject e) {
        if (Objects.equals(this.getView().getFormShowParameter().getStatus(), OperationStatus.VIEW)) {
            Object draftBillId = this.getView().getFormShowParameter().getCustomParam("draftBillId");
            DynamicObject receivableBill = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(draftBillId.toString()), (String)"cdm_receivablebill");
            List sortedRows = receivableBill.getDynamicObjectCollection("endorseentry").stream().filter(item -> item.getDate("signdate") != null).sorted((d1, d2) -> d2.getDate("signdate").compareTo(d1.getDate("signdate"))).collect(Collectors.toList());
            for (int i = 0; i < sortedRows.size(); ++i) {
                DynamicObject row = (DynamicObject)sortedRows.get(i);
                this.getView().invokeOperation("newentry");
                String endorseType = row.getString("endorsetype");
                this.getModel().setValue("type", (Object)BillEndorseTypeEnum.getName((String)endorseType), i);
                if (Objects.equals(endorseType, BillEndorseTypeEnum.PLEDGE.getValue())) {
                    this.fillPledge(row, i);
                    continue;
                }
                if (Objects.equals(endorseType, BillEndorseTypeEnum.TRANSFER.getValue())) {
                    this.fillTransfer(row, i);
                    continue;
                }
                if (Objects.equals(endorseType, BillEndorseTypeEnum.PROMISE.getValue())) {
                    this.fillPromise(row, i);
                    continue;
                }
                if (!Objects.equals(endorseType, BillEndorseTypeEnum.NOTEDISCOUNT.getValue())) continue;
                this.fillNoteDiscount(row, i);
            }
        }
    }

    private void fillPromise(DynamicObject row, int i) {
        this.getModel().setValue(LABELAP_1, (Object)ResManager.loadKDString((String)"\u662f\u5426\u8f6c\u8ba9\uff1a", (String)"DraftBillBackEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_2, (Object)(row.getBoolean("endorseistransfer") ? BooleanEnum.TRUE.getName() : BooleanEnum.FALSE.getName()), i);
        this.getModel().setValue(LABELAP_3, (Object)ResManager.loadKDString((String)"\u4fdd\u8bc1\u65e5\u671f\uff1a", (String)"DraftBillBackEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_4, (Object)DateUtils.formatString((Date)row.getDate("signdate"), (String)"yyyy-MM-dd"), i);
        this.getModel().setValue(LABELAP_5, (Object)ResManager.loadKDString((String)"\u88ab\u4fdd\u8bc1\u4eba\uff1a", (String)"DraftBillBackEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_6, (Object)row.getString("initiatorname"), i);
        this.getModel().setValue(LABELAP_7, (Object)ResManager.loadKDString((String)"\u4fdd\u8bc1\u4eba\uff1a", (String)"DraftBillBackEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_8, (Object)row.getString("opponentname"), i);
    }

    private void fillTransfer(DynamicObject row, int i) {
        this.getModel().setValue(LABELAP_1, (Object)ResManager.loadKDString((String)"\u662f\u5426\u8f6c\u8ba9\uff1a", (String)"DraftBillBackEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_2, (Object)(row.getBoolean("endorseistransfer") ? BooleanEnum.TRUE.getName() : BooleanEnum.FALSE.getName()), i);
        this.getModel().setValue(LABELAP_3, (Object)ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"DraftBillBackEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_4, (Object)DateUtils.formatString((Date)row.getDate("signdate"), (String)"yyyy-MM-dd"), i);
        this.getModel().setValue(LABELAP_5, (Object)ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"DraftBillBackEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_6, (Object)row.getString("initiatorname"), i);
        this.getModel().setValue(LABELAP_7, (Object)ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"DraftBillBackEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_8, (Object)row.getString("opponentname"), i);
    }

    private void fillPledge(DynamicObject dynamicObject, int i) {
        this.getModel().setValue(LABELAP_1, (Object)ResManager.loadKDString((String)"\u51fa\u8d28\u65e5\u671f\uff1a", (String)"DraftBillBackEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_2, (Object)DateUtils.formatString((Date)dynamicObject.getDate("signdate"), (String)"yyyy-MM-dd"), i);
        this.getModel().setValue(LABELAP_3, (Object)ResManager.loadKDString((String)"\u8d28\u62bc\u89e3\u9664\u65e5\u671f\uff1a", (String)"DraftBillBackEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_4, (Object)DateUtils.formatString((Date)dynamicObject.getDate("pledgereleasedate"), (String)"yyyy-MM-dd"), i);
        this.getModel().setValue(LABELAP_5, (Object)ResManager.loadKDString((String)"\u51fa\u8d28\u4eba\uff1a", (String)"DraftBillBackEdit_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_6, (Object)dynamicObject.getString("initiatorname"), i);
        this.getModel().setValue(LABELAP_7, (Object)ResManager.loadKDString((String)"\u8d28\u6743\u4eba\uff1a", (String)"DraftBillBackEdit_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(LABELAP_8, (Object)dynamicObject.getString("opponentname"), i);
    }

    private void fillNoteDiscount(DynamicObject row, int i) {
        this.getModel().setValue(LABELAP_1, (Object)ResManager.loadKDString((String)"\u662f\u5426\u8f6c\u8ba9\uff1a", (String)"DraftBillBackEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_2, (Object)(row.getBoolean("endorseistransfer") ? BooleanEnum.TRUE.getName() : BooleanEnum.FALSE.getName()), i);
        this.getModel().setValue(LABELAP_3, (Object)ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"DraftBillBackEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_4, (Object)DateUtils.formatString((Date)row.getDate("signdate"), (String)"yyyy-MM-dd"), i);
        this.getModel().setValue(LABELAP_5, (Object)ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"DraftBillBackEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_6, (Object)row.getString("initiatorname"), i);
        this.getModel().setValue(LABELAP_7, (Object)ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"DraftBillBackEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), i);
        this.getModel().setValue(LABELAP_8, (Object)row.getString("opponentname"), i);
    }
}

